package com.huigou.topsun.sap.finaCustomer.application;

import com.huigou.topsun.sap.finaCustomer.domain.FinaCustomerInfo;
import com.huigou.topsun.sap.finaCustomer.domain.query.FinaCustomerQueryRequest;
import com.huigou.util.SDO;

import java.util.List;
import java.util.Map;

public interface FinaCustomerApplication {

    String PROCESS_DEFINITION_KEY = "finaCustomerProc";
    String PROCESS_DEFINITION_KEY2 = "finaCustomerModiProc";
    String PROCESS_DEFINITION_KEY3 = "finaCustomerDeleProc";
    String PROCESS_DEFINITION_KEY4 = "finaCustomerExteProc";

    String QUERY_XML_FILE_PATH= "config/topsun/sap/finaCustomer/finaCustomer.xml";

    Map<String, Object> slicedFinaCustomerQuery(FinaCustomerQueryRequest query);


    FinaCustomerInfo loadFinaCustomerById(String id);

    Map<String, Object>  loadFinaCustomerPayDatas(FinaCustomerQueryRequest queryRequest);


    Map<String, Object>  loadFinaCustomerBankDatas(FinaCustomerQueryRequest queryRequest);

      List<Map<String, Object>> findDeletedFinaCustomerById(SDO params);

     void deleteFinaCustomerPaysByIds( List<String> ids);

    void deleteFinaCustomerBankByIds( List<String> ids);

    List<Map<String, String>> selectFinaCustomers(String types);

    String checkApprovalStatus(String partner);

    Map<String, String> getFinaCustomerNowItemList(String buPartner);
}
