package com.huigou.topsun.sap.exceptionReport.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Auther: lxh
 * @Date: 2024/08/21/15:05
 * @Description: 品质异常报告供应商 扣除应付款处理方式
 */
@Data
@Entity
@Table(name = "sap_exception_report_payable")
public class ExceptionReportPayable extends AbstractEntity {

    /**
     * 品质异常报告id
     */
    @Column(name = "exception_report_id")
    private String exceptionReportId;

    /**
     * 采购单号
     */
    @Column(name = "purchase_no")
    private String purchaseNo;
    //产品编码
    @Column(name = "product_code")
    private String productCode;
    //产品名称
    @Column(name = "product_name")
    private String productName;

    //数量
    @Column(name = "number")
    private BigDecimal number;

    //单位
    @Column(name = "unit")
    private String unit;
    //单位名称
    @Column(name = "unit_name")
    private String unitName;
    /**
     * 金额
     */
    @Column(name = "money")
    private BigDecimal money;


    /**
     * 日期
     */
    @Column(name = "send_date")
    private Date sendDate;

    /*
     *备注
     */
    @Column(name = "remark")
    private String remark;

}
