package com.huigou.topsun.sap.exceptionReport.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/20/17:05
 * @Description: 品质异常报告明细
 */
@Data
@Entity
@Table(name = "sap_exception_report_item")
public class ExceptionReportItem extends AbstractEntity {

    /**
     * 品质异常报告id
     */
    @Column(name = "exception_report_id")
    private String exceptionReportId;

    /**
     * 生产单号/采购/外发单号
     */
    @Column(name = "produce_no")
    private String produceNo;


    @Column(name = "product_type")
    private String productType;

    /**
     * 产品/原材料编码
     */
    @Column(name = "product_code")
    private String productCode;

    /**
     * 产品/原材料名称
     */
    @Column(name = "product_name")
    private String productName;

    /**
     * 单位
     */
    @Column(name = "unit")
    private String unit;

    /**
     * 单位描述
     */
    @Column(name = "unit_name")
    private String unitName;

    /**
     * 币别
     */
    @Column(name = "currency")
    private String currency;

    /**
     * 币别描述
     */
    @Column(name = "currency_name")
    private String currencyName;

    /**
     * 单价
     */
    @Column(name = "price")
    private BigDecimal price;

    /**
     * 数量
     */
    @Column(name = "number")
    private BigDecimal number;

    /**
     * 金额
     */
    @Column(name = "money")
    private BigDecimal money;

    /**
     * 转换成人民币金额
     */
    @Column(name = "rmb_money")
    private BigDecimal rmbMoney;


    /**
     * 出货日期
     */
    @Column(name = "send_date")
    private Date sendDate;

    //异常原因类型 用于区分是生产 2  还是供应商原材料的明细  1
    @Column(name = "reason_type")
    private String reasonType;

    /**
     * 异常数量
     */
    @Column(name = "exception_number")
    private BigDecimal exceptionNumber;

    /**
     * 汇率
     */
    @Column(name = "exchange_rate")
    private BigDecimal exchangeRate;

    /**
     * 运输费
     */
    @Column(name = "freight")
    private BigDecimal freight;

    /**
     * 返工费
     */
    @Column(name = "rework")
    private BigDecimal rework;

    /**
     * 停工待料费
     */
    @Column(name = "stop_wait_material")
    private BigDecimal stopWaitMaterial;

    /**
     * 开机费
     */
    @Column(name = "startup_fee")
    private BigDecimal startupFee;


    /**
     * 采购订单类型
     */
    @Column(name = "bsart")
    private String bsart;

    /**
     * 采购订单类型描述
     */
    @Column(name = "batxt")
    private String batxt;
}
