package com.huigou.topsun.sap.exceptionReport.application.impl;

import com.huigou.cache.DictUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.exceptionReport.application.ExceptionReportCashApplication;
import com.huigou.topsun.sap.exceptionReport.application.ExceptionReportDutyPersonApplication;
import com.huigou.topsun.sap.exceptionReport.domain.ExceptionReportCash;
import com.huigou.topsun.sap.exceptionReport.domain.ExceptionReportDutyPerson;
import com.huigou.topsun.sap.exceptionReport.domain.query.ExceptionReportQueryRequest;
import com.huigou.topsun.sap.exceptionReport.repository.ExceptionReportCashRepository;
import com.huigou.topsun.sap.exceptionReport.repository.ExceptionReportDutyPersonRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: lxh
 * @Date: 2024/08/21/19:36
 * @Description: 品质异常报告现金处理方式信息
 */
@Service("exceptionReportCashApplication")
public class ExceptionReportCashApplicationImpl extends BaseApplication implements ExceptionReportCashApplication {
    @Autowired
    private ExceptionReportCashRepository exceptionReportCashRepository;
    @Override
    public List<ExceptionReportCash> findByExceptionReportId(String exceptionReportId) {
        return exceptionReportCashRepository.findByExceptionReportId(exceptionReportId);
    }

    @Override
    public void saveExceptionReportCashList(String exceptionReportId, List<ExceptionReportCash> cashList) {
        for (ExceptionReportCash exceptionReportCash : cashList) {
            exceptionReportCash.setExceptionReportId(exceptionReportId);
            exceptionReportCashRepository.save(exceptionReportCash);
        }
    }

    @Override
    public Map<String, Object> slicedExceptionReportCashList(ExceptionReportQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getExceptionReportId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "exceptionReportCash");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            queryModel.putDictionary("payment", DictUtil.getDictionary("zwels"));
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        for (String id : ids) {
            exceptionReportCashRepository.delete(id);
        }
    }

    @Override
    public void saveExceptionReportCash(ExceptionReportCash exceptionReportCash) {
        exceptionReportCashRepository.save(exceptionReportCash);
    }
}
