package com.huigou.topsun.sap.costReimbursement.domain;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

/**
 * 
 * @TableName sap_cost_reimbursement_base_info
 */
@Table(name="sap_cost_reimbursement_base_info")
@Entity
@Data
public class SapCostReimbursement extends FlowBillAbstractEntity {


    /**
     * EP付款申请类别
     */
    @Column(name = "ZEP_FTYPE")
    private String zepFtype;

    /**
     * EP付款申请类别名称
     */
    @Column(name = "ZEP_FTYPENAME")
    private String zepFtypename;

    /**
     * 公司代码
     */
    @Column(name = "BUKRS")
    private String bukrs;

    /**
     * 公司代码名称
     */
    @Column(name = "BUTXT")
    private String butxt;

    /**
     * EP部门代码
     */
    @Column(name = "ZEP_DEPART")
    private String zepDepart;

    /**
     * EP部门名称
     */
    @Column(name = "ZEP_DEPARTNAME")
    private String zepDepartname;

    /**
     * EP流程申请人代码
     */
    @Column(name = "ZEP_APPLI")
    private String zepAppli;

    /**
     * EP流程申请人
     */
    @Column(name = "ZEP_APPLINAME")
    private String zepAppliname;

    /**
     * 付款申请创建日期
     */
    @Column(name = "ZEP_FCRDATE")
    private Date zepFcrdate;

    /**
     * EP流程单号
     */
    @Column(name = "ZEP_NO")
    private String zepNo;

    /**
     * 付款申请内容
     */
    @Column(name = "ZEP_TXT")
    private String zepTxt;

    /**
     * 申请总金额（本位币）
     */
    @Column(name = "ZEP_FTAMOUNT")
    private BigDecimal zepFtamount;

    /**
     * 申请总税额（本位币）
     */
    @Column(name = "ZEP_FTTAX")
    private BigDecimal zepFttax;

    /**
     * 申请总金额
     */
    @Column(name = "ZEP_FTAMOUNT1")
    private BigDecimal zepFtamount1;

    /**
     * 申请总税额
     */
    @Column(name = "ZEP_FTTAX1")
    private BigDecimal zepFttax1;

    /**
     * 审批总金额（本位币）
     */
    @Column(name = "ZEP_PTAMOUNT")
    private BigDecimal zepPtamount;

    /**
     * 审批总税额（本位币）
     */
    @Column(name = "ZEP_PTTAX")
    private BigDecimal zepPttax;

    /**
     * 审批总金额
     */
    @Column(name = "ZEP_PTAMOUNT1")
    private BigDecimal zepPtamount1;

    /**
     * 审批总税额
     */
    @Column(name = "ZEP_PTTAX1")
    private BigDecimal zepPttax1;


    /**
     * 消息类型
     */
    @JsonIgnore
    @Column(name = "MSG_TYPE")
    private String msgType;

    /**
     * 消息id
     */
    @JsonIgnore
    @Column(name = "MSG_ID")
    private String msgId;
    /**
     * 消息编号
     */
    @JsonIgnore
    @Column(name = "NUMBER")
    private String number;
    /**
     * 消息内容
     */
    @JsonIgnore
    @Column(name = "MESSAGE")
    private String message;
    /**
     * 日志编号
     */
    @JsonIgnore
    @Column(name = "LOG_NO")
    private String logNo;
    /**
     * 日志消息编号
     */
    @JsonIgnore
    @Column(name = "LOG_MSG_NO")
    private String logMsgNo;
    /**
     * 消息参数 1
     */
    @JsonIgnore
    @Column(name = "MESSAGE_V1")
    private String messageV1;
    /**
     * 消息参数 2
     */
    @JsonIgnore
    @Column(name = "MESSAGE_V2")
    private String messageV2;
    /**
     * 消息参数 3
     */
    @JsonIgnore
    @Column(name = "MESSAGE_V3")
    private String messageV3;
    /**
     * 消息参数 4
     */
    @JsonIgnore
    @Column(name = "MESSAGE_V4")
    private String messageV4;

    /**
     * 员工借款单据编号
     */
    @Column(name = "employee_loan_bill_code")
    private String employeeLoanBillCode;

    /**
     * 员工借款单据付款内容
     */
    @Column(name = "employee_Loan_text")
    private String employeeLoanText;

    /**
     * 付款附言
     */
    @Column(name = "ZEP_TXT1")
    private String zepTxt1;

    /**
     * 付款银行账号
     */
    @Column(name = "BANKN1")
    private String bankn1;

    /**
     * 付款银行账号名称
     */
    @Column(name = "ZT012K_TEXT1")
    private String zt012kText1;

    /**
     * 付款方式
     */
    @Column(name = "text1")
    private String text1;


    /**
     * 审批完成时间
     */
    @Column(name = "finished_date")
    private Date finishedDate;

    /**
     * BP
     */
    @Column(name = "PARTNER")
    private String partner;

    /**
     * BP银行账号
     */
    @Column(name = "BANKN")
    private String bankn;

    /**
     * BP账号名称
     */
    @Column(name = "KOINH")
    private String koinh;

    /**
     * BP联行号
     */
    @Column(name = "BANKL")
    private String bankl;

    /**
     * SWIFT/BIC
     */
    @Column(name = "SWIFT")
    private String swift;

    /**
     * 异常编号
     */
    @Column(name = "exception_no")
    private String exceptionNo;

    /**
     * 付款事由
     */
    @Column(name = "pay_reason")
    private String payReason;

    @Override
    protected String getCodeRuleId() {
        return "sapCostReimbursement";
    }
}