package com.huigou.topsun.sap.acceptanceFormAck.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huigou.context.Operator;
import com.huigou.topsun.sap.acceptanceFormAck.application.SapAcceptanceFormAckApplication;
import com.huigou.topsun.sap.acceptanceFormAck.domain.SapAcceptanceFormAck;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;

import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * SapAcceptanceFormAck 验收单标记控制类
 *
 * @author qinzhenguan
 * @createDate 2024/01/22 16:05
 **/
@RequiredArgsConstructor
@Controller
@ControllerMapping("/sapAcceptanceForm")
public class SapAcceptanceFormAckController extends CommonController {

    private final SapAcceptanceFormAckApplication ackServer;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/acceptanceFormAck/";
    }

    public String forwardAcceptanceForm() {
        SDO sdo = this.getSDO();
        Operator operator = sdo.getOperator();
        String loginCode = operator.getLoginUser().getLoginName();
        HashMap<String, Object> param = new HashMap<>(3);
        param.put("loginCode", loginCode);
        return forward("acceptanceFormAck", param);
    }

    public String findAcceptanceForm() {
        SDO sdo = this.getSDO();
        HashMap<Object, Object> map = new HashMap<>(6);
        if(sdo.getProperties().size() <= 3) {
            return toResult(map);
        }
        ArrayList<Map<String, Object>> list = ackServer.findAcceptanceForm(sdo);
        map.put("Rows", list);
        return toResult(map);
    }

    public String ackAcceptanceForm() {
        SDO sdo = this.getSDO();
        String s = ackServer.ackAcceptanceForm(sdo);
        return toResult(s);
    }

    @SkipAuth
    public String saveAcceptanceForm() {
        HttpServletRequest request = this.getRequest();
        String requestBody = "";
        try (InputStream ist = request.getInputStream();
             InputStreamReader istr = new InputStreamReader(ist, StandardCharsets.UTF_8);) {
            requestBody = new BufferedReader(istr).lines().collect(Collectors.joining("\n"));
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println("save requestBody :  "+ requestBody);

        return success();
    }

    @SkipAuth
    public String queryAcceptanceForm() throws JsonProcessingException {
        HttpServletRequest request = this.getRequest();
        SapAcceptanceFormAck acceptanceForm;
        try (InputStream ist = request.getInputStream();
             InputStreamReader istr = new InputStreamReader(ist, StandardCharsets.UTF_8);) {
            String requestBody = new BufferedReader(istr).lines().collect(Collectors.joining("\n"));
            ObjectMapper objectMapper = new ObjectMapper();
            acceptanceForm = objectMapper.readValue(requestBody, SapAcceptanceFormAck.class);

        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        String acceptanceForms = ackServer.queryAcceptanceForms(acceptanceForm);
        return success(acceptanceForms);
    }

}