package com.huigou.topsun.ep.order.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.ep.order.application.EpSaleOrderCancelApplication;
import com.huigou.topsun.ep.order.domain.EpSaleOrderCancel;
import com.huigou.topsun.ep.order.domain.query.EpSaleOrderCancelQueryRequest;
import com.huigou.topsun.ep.order.domain.vo.EpSaleOrderCancelVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.JSONUtil;
import com.huigou.util.SDO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/12/19:13
 * @Description:
 */
@Controller
@ControllerMapping("/epSaleOrderCancel")
public class EpSaleOrderCancelController extends CommonController {

    private final static Logger LOG = LoggerFactory.getLogger(EpSaleOrderCancelController.class);
    @Override
    protected String getPagePath() {
        return "/biz/topsun/ep/epSaleOrder/";
    }

    @Resource
    private EpSaleOrderCancelApplication epSaleOrderCancelApplication;

    public String forwardEpSaleOrderCancelList(){
        return forward("epSaleOrderCancelList");
    }

    public String slicedEpSaleOrderCancelList(){
        SDO sdo = this.getSDO();
        EpSaleOrderCancelQueryRequest queryRequest = sdo.toQueryRequest(EpSaleOrderCancelQueryRequest.class);
        Map<String, Object> map = epSaleOrderCancelApplication.slicedEpSaleOrderCancelList(queryRequest);
        return toResult(map);
    }

    public String forwardEpSaleOrderCancelDetail(){
        this.putAttribute("processDefinitionKey", EpSaleOrderCancelApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        EpSaleOrderCancel epSaleOrderCancel = new EpSaleOrderCancel();
        epSaleOrderCancel.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        epSaleOrderCancel.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("epSaleOrderCancelDetail",epSaleOrderCancel);
    }

    public String showEpSaleOrderCancelDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        EpSaleOrderCancel epSaleOrderCancel = epSaleOrderCancelApplication.findEpSaleOrderCancelById(id);
        return forward("epSaleOrderCancelDetail",epSaleOrderCancel);
    }

    @SkipAuth
    @RequestMapping( value = "/getEpSaleOrderCancel")
    @ResponseBody
    public HashMap<String, Object> getEpSaleOrderCancel(@RequestBody List<EpSaleOrderCancelVo> epSaleOrderCancelVos){
        //SDO sdo = this.getSDO();
        HashMap<String, Object> messageMap = new HashMap<>();
        messageMap.put("Message_Status","S");
        messageMap.put("Message_Text","成功");
        LOG.info("EP销售订单取消/变更审批数据=={}", JSONUtil.toString(epSaleOrderCancelVos));
        try {
            this.epSaleOrderCancelApplication.saveEpSaleOrderCancelVo(epSaleOrderCancelVos);
        }catch (RuntimeException e){
            messageMap.put("Message_Status","E");
            messageMap.put("Message_Text",e.getMessage());
        }
        return messageMap;
    }
}
