package com.huigou.topsun.ep.order.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.ep.order.domain.EpSaleOrderItem;
import com.huigou.topsun.ep.order.repository.EpSaleOrderItemRepository;
import com.huigou.topsun.ep.order.application.EpSaleOrderItemApplication;
import com.huigou.topsun.ep.order.domain.query.EpSaleOrderQueryRequest;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/12/19:20
 * @Description:
 */
@Service("epSaleOrderItemApplication")
public class EpSaleOrderItemApplicationImpl extends BaseApplication implements EpSaleOrderItemApplication {
    @Autowired
    private EpSaleOrderItemRepository epSaleOrderItemRepository;
    @Override
    public void saveEpSaleOrderItems(String epSaleOrderId, List<EpSaleOrderItem> epSaleOrderItems) {
        epSaleOrderItems.forEach(epSaleOrderItem -> {
            epSaleOrderItem.setEpSaleOrderId(epSaleOrderId);
            epSaleOrderItemRepository.save(epSaleOrderItem);
        });
    }

    @Override
    public Map<String, Object> queryEpSaleOrderItems(EpSaleOrderQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getEpSaleOrderId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "epSaleOrderItems");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            epSaleOrderItemRepository.delete(id);
        });
    }

    @Override
    public List<EpSaleOrderItem> findByEpSaleOrderId(String epSaleOrderId) {
        return epSaleOrderItemRepository.findByEpSaleOrderId(epSaleOrderId);
    }
}
