package com.huigou.topsun.ep.change.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/06/19/9:53
 * @Description: 宝绅内部变更申请/通知单
 */
@Data
@Entity
@Table(name = "ep_change_form")
public class EpChangeForm extends FlowBillAbstractEntity {
    /**
     * 品牌编码
     */
    @Column(name = "brand_code")
    private String brandCode;

    /**
     * 品牌名称
     */
    @Column(name = "brand_name")
    private String brandName;

    /**
     * 变更原因
     * REASON FOR CHANGE变更原因:
     * □ BRAND CHANGE客户变更      □ BSN PROCESS CHANGE内部工艺变更       □ OTHERS其它
     */
    @Column(name = "reason_for_change")
    private String reasonForChange;

    /**
     * 原因描述
     */
    @Column(name = "reason_desc")
    private String reasonDesc;

    /**
     * 其他原因描述
     */
    @Column(name = "other_reason_desc")
    private String otherReasonDesc;

    /**
     * 生效日期:
     * □ IMMEDIATE立即变更           □ RUNNING CHANGE 正常变更（用完后变更）  £ SEASON换季更改
     */
    @Column(name = "change_effective")
    private String changeEffective;

    /**
     * 具体生效日期
     */
    @Column(name = "effective_date")
    private Date effectiveDate;

    //CURRENT SPEC 目前产品信息

    /**
     * 产品代号
     */
    @Column(name = "pd")
    private String pd;

    /**
     * 产品名称
     */
    @Column(name = "product_name")
    private String productName;

    /**
     * 制程工艺
     */
    @Column(name = "process")
    private String process;

    /**
     * 涉及成品编码
     */
    @Column(name = "other_process")
    private String otherProcess;

    /**
     * 原材料
     */
    @Column(name = "material")
    private String material;

    /**
     * 旧原材料库存
     */
    @Column(name = "old_material")
    private String oldMaterial;

    /**
     * 其他
     */
    @Column(name = "others")
    private String others;

    /**
     * 涉及原材料成品库存
     */
    @Column(name = "others_material_store")
    private String othersMaterialStore;


    //变更后产品信息

    /**
     * 产品代号
     */
    @Column(name = "changed_pd")
    private String changedPd;

    /**
     * 产品名称
     */
    @Column(name = "changed_product_name")
    private String changedProductName;

    /**
     * 制程工艺
     */
    @Column(name = "changed_process")
    private String changedProcess;

    /**
     * 原材料
     */
    @Column(name = "changed_material")
    private String changedMaterial;

    /**
     * 其他
     */
    @Column(name = "changed_others")
    private String changedOthers;

    /**
     * 版本id
     */
    @Column(name = "production_solution_id")
    private String productionSolutionId;

    @Column(name = "code")
    private String code;

    @Column(name = "msg")
    private String msg;

    /**
     * 变更人员id
     */
    @Column(name = "change_person_id")
    private String changePersonId;

    /**
     * 变更人员
     */
    @Column(name = "change_person")
    private String changePerson;

    /**
     * 变更单排序
     */
    @Column(name = "change_no")
    private String changeNo;

    /**
     * 变更事项
     */
    @Column(name = "change_matter")
    private String changeMatter;

    /**
     * 原材料变更原因
     * 0，材料性能不稳定
     * 1，替换材料
     * 2，供应商材料停产
     * 3，供应商材料升级
     * 4，其他
     */
    @Column(name = "material_reason_for_change")
    private String materialReasonForChange;
    @Override
    protected String getCodeRuleId() {
        return "epChangeForm";
    }
}
