package com.huigou.topsun.ep.change.controller;

import com.huigou.cache.DictUtil;
import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.ep.change.application.EpChangeFormApplication;
import com.huigou.topsun.ep.change.application.EpChangeFormImplItemApplication;
import com.huigou.topsun.ep.change.application.EpChangeFormStockItemApplication;
import com.huigou.topsun.ep.change.domain.EpChangeForm;
import com.huigou.topsun.ep.change.domain.query.EpChangeFormQueryRequest;
import com.huigou.topsun.sap.purchaseInfoRecord.application.SapPurchaseInfoRecordApplication;
import com.huigou.topsun.sap.purchaseInfoRecord.domain.SapPurchaseInfoRecord;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.bmp.fn.CodeGenerator;
import com.huigou.uasp.bpm.engine.application.ActApplication;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.ClassHelper;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/06/19/10:05
 * @Description:
 */
@Controller
@ControllerMapping("/epChangeForm")
public class EpChangeFormController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/ep/change/";
    }

    @Resource
    private EpChangeFormApplication epChangeFormApplication;
    @Autowired
    private EpChangeFormImplItemApplication changeFormImplItemApplication;
    @Autowired
    private EpChangeFormStockItemApplication changeFormStockItemApplication;
    @Autowired
    private CodeGenerator codeGenerator;

    public String forwardEpChangeFormList(){
        return forward("epChangeFormList");
    }

    public String slicedEpChangeFormList(){
        SDO sdo = this.getSDO();
        EpChangeFormQueryRequest queryRequest = sdo.toQueryRequest(EpChangeFormQueryRequest.class);
        Map<String, Object> map = epChangeFormApplication.slicedEpChangeFormList(queryRequest);
        return toResult(map);
    }

    public String forwardEpChangeFormDetail(){
        this.putAttribute("processDefinitionKey", EpChangeFormApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        EpChangeForm epChangeForm = new EpChangeForm();
        epChangeForm.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        epChangeForm.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));

        //ECN{yyyy}-{4}
        String epChangeFormNo = codeGenerator.getNextCode("epChangeFormNo");

        //ECN{yyyyMMdd}-{4}
        String billCode = epChangeForm.getBillCode();
        // 提取A中-后面的部分
        String suffixA = epChangeFormNo.substring(epChangeFormNo.indexOf("-") + 1);

        // 提取B中-前面的部分
        String prefixB = billCode.substring(0, billCode.indexOf("-") + 1);

        // 组合成新字符串
        billCode = prefixB + suffixA;
        //把年月日的流水号替换成年的流水号
        epChangeForm.setBillCode(billCode);
        Map<String, String> reasonForChange = new HashMap<>();
        String type = this.getSDO().getString("type");
        if ("product".equals(type)){
            reasonForChange = DictUtil.getDictionary("reasonForChange");
            //reasonForChange.remove("MATERIAL CHANGE");
            this.putAttribute("reasonForChangeList",reasonForChange);
            return forward("epChangeFormDetail",epChangeForm);
        }else {
            //epChangeForm.setReasonForChange("MATERIAL CHANGE");
            return forward("epMaterialChangeFormDetail",epChangeForm);
        }
    }

    public String showEpChangeFormDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        EpChangeForm epChangeForm = epChangeFormApplication.findEpChangeFormById(id);
        Map<String, String> reasonForChange = new HashMap<>();
        if ("".equals(epChangeForm.getReasonForChange())){
            return forward("epMaterialChangeFormDetail",epChangeForm);
        }
        reasonForChange = DictUtil.getDictionary("reasonForChange");
        //reasonForChange.remove("MATERIAL CHANGE");
        this.putAttribute("reasonForChangeList",reasonForChange);
        return forward("epChangeFormDetail",epChangeForm);
    }

    public String slicedEpChangeFormImplItems(){
        SDO sdo = this.getSDO();
        EpChangeFormQueryRequest queryRequest = sdo.toQueryRequest(EpChangeFormQueryRequest.class);
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getEpChangeFormId())){
            map = changeFormImplItemApplication.findByEpChangeFormId(queryRequest);
        }
        if (StringUtil.isNotBlank(queryRequest.getOldId()) && StringUtil.isBlank(queryRequest.getEpChangeFormId())){
            map = changeFormImplItemApplication.findByOldId(queryRequest);
        }
        return toResult(map);
    }

    public String slicedEpChangeFormStockItems(){
        SDO sdo = this.getSDO();
        EpChangeFormQueryRequest queryRequest = sdo.toQueryRequest(EpChangeFormQueryRequest.class);
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getEpChangeFormId())){
            map = changeFormStockItemApplication.findByEpChangeFormId(queryRequest);
        }
        if (StringUtil.isNotBlank(queryRequest.getOldId()) && StringUtil.isBlank(queryRequest.getEpChangeFormId())){
            map = changeFormStockItemApplication.findByOldId(queryRequest);
        }
        return toResult(map);
    }

    public String deleteEpChangeFormImplItem(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        changeFormImplItemApplication.deleteItems(ids);
        return success();
    }

    public String deleteEpChangeFormStockItem(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        changeFormStockItemApplication.deleteItems(ids);
        return success();
    }

    /**
     * 打印
     * @return
     */
    public String print() {
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        EpChangeFormQueryRequest queryRequest = sdo.toQueryRequest(EpChangeFormQueryRequest.class);
        queryRequest.setId(id);
        Map<String,Object> map = this.epChangeFormApplication.print(queryRequest);
        String pintPage = String.format((String) map.get("printPage"));
        return outputAndProcUnitHandlerPDF(pintPage, id, map);
    }

    /**
     * 复制功能
     * @return
     */
    public String copyEpChangeForm(){
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");
        this.putAttribute("oldId", id);
        this.putAttribute("processDefinitionKey", EpChangeFormApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        EpChangeForm epChangeFormDb = epChangeFormApplication.findEpChangeFormById(id);
        EpChangeForm epChangeForm = new EpChangeForm();
        ClassHelper.copyProperties(epChangeFormDb,epChangeForm);
        epChangeForm.setId("");
        epChangeForm.setBillCode("");
        epChangeForm.setCode("");
        epChangeForm.setMsg("");
        epChangeForm.setStatusId(BizBillStatus.APPLYING.getId());
        Operator operator = getOperator();
        epChangeForm.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        Map<String, String> reasonForChange = new HashMap<>();
        if ("".equals(epChangeForm.getReasonForChange())){
            return forward("epMaterialChangeFormDetail",epChangeForm);
        }else {
            reasonForChange = DictUtil.getDictionary("reasonForChange");
            this.putAttribute("reasonForChangeList",reasonForChange);
            return forward("epChangeFormDetail",epChangeForm);
        }
    }
}
