package com.huigou.topsun.base.attachmentExplain.application;


import com.huigou.topsun.base.attachmentExplain.domain.model.AttachmentExplain;
import com.huigou.topsun.base.attachmentExplain.domain.query.AttachmentExplainQueryRequest;

import java.util.List;
import java.util.Map;


/**
 * 附件上传说明接口层
 * 
 * @author
 * @date 2018-04-02 14:20
 */
public interface AttachmentExplainApplication {

    /*
     * 查询文件
     */
    String QUERY_XML_FILE_PATH = "config/topsun/base/attachmentExplain.xml";

    /*
     * 查询表 hxAttachmentExplain
     */
    String QUERY_ATTACHMENT_EXPLAIN = "attachmentExplain";

    /**
     * 保存 附件上传说明
     * 
     * @author
     * @param params
     */
    String saveAttachmentExplain(AttachmentExplain attachmentExplain);

    /**
     * 加载 附件上传说明
     * 
     * @author
     * @return SDO
     */
    AttachmentExplain loadAttachmentExplain(String id);

    /**
     * 删除 附件上传说明
     * 
     * @author
     */

    void deleteAttachmentExplain(List<String> ids);

    /**
     * 修改状态
     */
    void updateAttachmentExplainStatus(List<String> ids, Integer status);

    /**
     * 查询 附件上传说明
     * 
     * @author
     * @return SDO
     */
    Map<String, Object> slicedQueryAttachmentExplain(AttachmentExplainQueryRequest queryRequest);

    AttachmentExplain loadAttachmentExplainByCode(String code);

}
