var gridManager = null;

$(document).ready(function () {
    initUI();
    loadGrid();
})
function initUI() {
    UICtrl.initDefaultLayout();
}

function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: addHandler,
    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {display: "单据编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "创建日期", name: "fillinDate", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请状态", name: "statusTextView", width: 60, minWidth: 60, type: "string", align: "left"},
            {display: "申请人", name: "personMemberName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请部门", name: "deptName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "公司代码", name: "burks", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "回收商", name: "bktxt", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "回收日期", name: "budat", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "收款方式", name: "paymentMethodTextView", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "合计金额", name: "totalMoney", width: 120, minWidth: 60, type: "number", align: "right"},
            {display: "车牌号", name: "carNo", width: 160, minWidth: 60, type: "string", align: "left"},
            {display: "备注", name: "remark", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "消息类型", name: "type", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "会计凭证编号", name: "messageV1", width: 200, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/wasteSale/slicedWasteSaleList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id);
        },
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'wasteSale',
        text: "新增废品销售单",
        url: web_app.name + '/wasteSale/forwardWasteSaleDetail.job'
    });
}

function doView(id) {
    UICtrl.addTabItem({
        tabid: 'wasteSale'+id,
        text: "查看废品销售单",
        url: web_app.name + '/wasteSale/showWasteSaleDetail.job?bizId='+id+"&isReadOnly=true"
    });
}
