<%@ page language="java" contentType="text/html; charset=utf-8" %>
<%@taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <script type="text/javascript">
      var applyType ="${applyType}";
    </script>
    <x:base include="layout,dialog,grid,tree,combox,commonTree,date,attachment"/>
    <x:script src='/biz/topsun/sap/suppliers/suppliersExtendDataDetail.js'/>
</head>
<body>
<x:billTitle title="供应商主数据扩展申请表" needStatus="false" needPerson="true"/>
<form class="hg-form" method="post" action="" id="submitForm">
        <x:hidden name="id"/>
        <x:hidden name="sId"/>
        <x:hidden name="applyType"/>
<%--        <x:hidden name="billCode"/>--%>
<%--        <x:hidden name="fillinDate" type="datetime"/>--%>
        <x:hidden name="fullId"/>
        <x:hidden name="organId"/>
        <x:hidden name="organName"/>
        <x:hidden name="deptId"/>
<%--        <x:hidden name="deptName"/>--%>
        <x:hidden name="positionId"/>
        <x:hidden name="positionName"/>
        <x:hidden name="personMemberId"/>
        <x:hidden name="statusId"/>
<%--        <x:hidden name="personMemberName"/>--%>
    <x:title title="申请人填写区域" name="group"/>
    <div class="hg-form-cols">
        <div class="hg-form-row">
            <x:inputC name="billCode" label="申请单编号" labelCol="1" readonly="true" fieldCol="2"/>
            <x:inputC name="personMemberName" label="申请人" readonly="true" labelCol="1" fieldCol="2"/>
            <x:inputC name="deptName" label="申请部门" readonly="true" labelCol="1" fieldCol="2"/>
            <x:inputC name="fillinDate" label="申请日期" readonly="true" wrapper="date" labelCol="1" fieldCol="2"/>
        </div>

    </div>
    <x:title title="供应商主数据" name="group"/>
    <div class="hg-form-cols">
        <div class="hg-form-row">
            <x:inputC name="rltgr" label="业务伙伴角色" labelCol="1" fieldCol="2" required="true" readonly="true"/>
            <x:selectC name="buGroup" label="业务伙伴分组" labelCol="1" fieldCol="2" required="true" dictionary="buGroup" disabled="true"/>
            <x:inputC name="partner" label="供应商编码" labelCol="1" fieldCol="2" required="false" readonly="true"/>
            <x:selectC name="title" label="称谓代码" labelCol="1" fieldCol="2" dictionary="title" disabled="true"/>
        </div>
        <div class="hg-form-row">
            <x:inputC name="nameOrg1" label="供应商名称1" labelCol="1" fieldCol="2" required="true" readonly="true"/>
            <x:inputC name="nameOrg2" label="供应商名称2" labelCol="1" fieldCol="2" readonly="true"/>
            <x:inputC name="buSort1" label="搜索词1" labelCol="1" fieldCol="2" required="true" readonly="true"/>
            <x:inputC name="buSort2" label="搜索词2" labelCol="1" fieldCol="2" readonly="true"/>
        </div>
        <div class="hg-form-row">
            <x:inputC name="land1Name" label="国家" labelCol="1" fieldCol="2" required="true" wrapper="select" readonly="true"/>
            <x:hidden name="land1"/>
            <x:inputC name="regionName" label="地区" labelCol="1" fieldCol="2" required="true" wrapper="select" readonly="true"/>
            <x:hidden name="region"/>
            <x:inputC name="city1" label="城市" labelCol="1" fieldCol="2" required="true" readonly="true"/>
            <x:inputC name="postCode1" label="城市邮政编码" labelCol="1" fieldCol="2" required="true" maxLength="6" readonly="true"/>
        </div>
        <div class="hg-form-row">
            <x:inputC name="street" label="街道地址" labelCol="1" fieldCol="2" maxLength="35" readonly="true"/>
            <x:inputC name="strSuppl1" label="街道2" labelCol="1" fieldCol="2" maxLength="35" readonly="true"/>
            <x:inputC name="strSuppl2" label="街道3" labelCol="1" fieldCol="2" maxLength="35" readonly="true"/>
            <x:inputC name="strSuppl3" label="街道4" labelCol="1" fieldCol="2" maxLength="35" readonly="true"/>
        </div>
        <div class="hg-form-row">
            <x:selectC name="langu" label="语言" labelCol="1" fieldCol="2" required="true" dictionary="langu" disabled="true"/>
            <x:inputC name="kunnr" label="客户编号" labelCol="1" fieldCol="2" readonly="true"/>
            <x:inputC name="stenr" label="税号" labelCol="1" fieldCol="2" required="true" maxLength="18" readonly="true"/>
            <x:inputC name="mobNumber" label="移动电话" labelCol="1" fieldCol="2" readonly="true"/>

        </div>
        <x:title title="联系人信息" name="group"/>
        <div class="hg-form-row">
            <x:inputC name="contact" label="联系人" labelCol="1" fieldCol="2" readonly="true"/>
            <x:inputC name="telNumber" label="电话" labelCol="1" fieldCol="2" readonly="true"/>
            <x:inputC name="faxNumber" label="传真" labelCol="1" fieldCol="2" maxLength="30" readonly="true"/>
            <x:inputC name="smtpAddr" label="电子邮件地址" labelCol="1" fieldCol="2" maxLength="30" match="email" readonly="true"/>
        </div>
        <div class="hg-form-row">
            <x:inputC name="contact1" label="联系人1" labelCol="1" fieldCol="2" readonly="true"/>
            <x:inputC name="telNumber1" label="电话1" labelCol="1" fieldCol="2" readonly="true"/>
            <x:inputC name="faxNumber1" label="传真1" labelCol="1" fieldCol="2" maxLength="30" readonly="true"/>
            <x:inputC name="smtpAddr1" label="电子邮件地址1" labelCol="1" fieldCol="2" maxLength="30" match="email" readonly="true"/>
        </div>
        <div class="hg-form-row">
            <x:inputC name="contact2" label="联系人2" labelCol="1" fieldCol="2" readonly="true"/>
            <x:inputC name="telNumber2" label="电话2" labelCol="1" fieldCol="2" readonly="true"/>
            <x:inputC name="faxNumber2" label="传真2" labelCol="1" fieldCol="2" maxLength="30" readonly="true"/>
            <x:inputC name="smtpAddr2" label="电子邮件地址2" labelCol="1" fieldCol="2" maxLength="30" match="email" readonly="true"/>
        </div>
        <div class="hg-form-row">
            <x:inputC name="contact3" label="联系人3" labelCol="1" fieldCol="2" readonly="true"/>
            <x:inputC name="telNumber3" label="电话3" labelCol="1" fieldCol="2" readonly="true"/>
            <x:inputC name="faxNumber3" label="传真3" labelCol="1" fieldCol="2" maxLength="30" readonly="true"/>
            <x:inputC name="smtpAddr3" label="电子邮件地址3" labelCol="1" fieldCol="2" maxLength="30" match="email" readonly="true"/>
        </div>
        <div class="hg-form-row">
            <x:selectC name="sperr" label="中心记帐冻结" labelCol="1" fieldCol="2" dictionary="sperr" disabled="true"/>
            <x:selectC name="sperm" label="集中设置的采购冻结" labelCol="2" fieldCol="1" dictionary="sperrB" disabled="true"/>
        </div>
        <x:title title="供应商银行信息" name="group"/>
        <div class="hg-form-row">
            <x:selectC name="banks" label="银行所属国家" labelCol="1" fieldCol="2" required="true" dictionary="country" disabled="true"/>
            <x:inputC name="bankl" label="银行代码" labelCol="1" fieldCol="2" required="true" readonly="true"/>
            <x:inputC name="banka" label="银行名称" labelCol="1" fieldCol="2" required="false" readonly="true"/>
            <x:inputC name="bankn" label="银行帐户号码" labelCol="1" fieldCol="2" required="true" maxLength="18" readonly="true"/>
            <x:inputC name="bkref" label="银行细目的参考明细" labelCol="1" fieldCol="2" required="false" maxLength="18" readonly="true"/>
            <x:inputC name="koinh" label="账户持有人姓名" labelCol="1" fieldCol="2" required="false" readonly="true"/>
        </div>
    </div>
    <div style="padding-top: 15px;">
        <x:fileList bizCode="supplier" bizId="attbizId" id="supplierList" title="营业执照/开票资料" />
    </div>
    <div class="blank_div clearfix"></div>
    <x:title title="供应商采购组织信息" name="group"/>
    <div id="sapSuppliersBuyerGrid" style="margin: 2px;"></div>
    <div class="blank_div clearfix"></div>
    <x:title title="供应商子范围" name="group"/>
    <div id="sapSuppliersItemPeriodGrid" style="margin: 2px;"></div>
    <div class="blank_div clearfix"></div>
    <x:title title="供应商公司信息" name="group"/>
    <div id="sapSuppliersPayGrid" style="margin: 2px;"></div>
    <div class="blank_div clearfix"></div>
</form>
</body>
</html>
