<%@ page contentType="text/html; charset=utf-8" language="java" %>
<%@ taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <x:base include="layout,date,grid,combox,dialog,comboDialog,attachment,selectOrg"/>
    <x:script src='/biz/topsun/sap/produceSupplierReview/produceSupplierReviewDetail.js'/>
    <%--<x:script src='/biz/topsun/sap/produceSupplierReview/newSupplierReviewInfo.js'/>--%>
</head>
<body>
<x:billTitle title="生产类供应商准入评审表-供方调查表" needStatus="true" needPerson="true"/>
<form class="hg-form" method="post" action="" id="submitForm">
    <x:hidden name="mode"/>
    <x:hidden name="id"/>
    <x:hidden name="tempId"/>
    <x:hidden name="version"/>
    <x:hidden name="billCode"/>
    <x:hidden name="fillinDate"/>
    <x:hidden name="fullId"/>
    <x:hidden name="organId"/>
    <x:hidden name="organName"/>
    <x:hidden name="deptId"/>
    <x:hidden name="deptName"/>
    <x:hidden name="positionId"/>
    <x:hidden name="positionName"/>
    <x:hidden name="personMemberId"/>
    <x:hidden name="personMemberName"/>
    <x:hidden name="statusId"/>
    <x:hidden name="attbizId"/>
    <div class="container-fluid">
        <div id="produceSupplierReview-ledger-tab">
            <div class="ui-tab-links">
                <ul>
                    <li id="produceSupplierReview" divid="produceSupplierReviewInfo"><x:message key="供方调查表"/></li>
                    <li id="newSupplierReview" divid="newSupplierReviewInfo"><x:message key="新供应商评审表"/></li>
                </ul>
            </div>
            <div class="ui-tab-content">
                <div class="layout">
                    <div id="produceSupplierReviewInfo" style="margin: 2px;">
                        <div class="hg-form-row">
                            <x:inputC name="name" title="供应商名称" required="false" label="供应商名称" labelCol="2" fieldCol="6"/>
                            <x:inputC name="tel" title="电话号码" required="false" label="电话号码" labelCol="2" fieldCol="2"/>
                        </div>
                        <div class="hg-form-row">
                            <x:inputC name="address" title="公司地址" label="公司地址" required="false" labelCol="2" fieldCol="6"/>
                            <x:inputC name="fax" title="传真号码" required="false" label="传真号码" labelCol="2" fieldCol="2"/>
                        </div>
                        <div class="hg-form-row">
                            <x:inputC name="companyNature" title="公司性质" required="false"  label="公司性质" labelCol="2" fieldCol="2"/>
                            <x:inputC name="businessContact" title="业务联系人" label="业务联系人" required="false" labelCol="2" fieldCol="2"/>
                            <x:inputC name="responsiblePerson" title="公司负责人" required="false" label="公司负责人" labelCol="2" fieldCol="2"/>
                        </div>
                        <div class="hg-form-row">
                            <x:inputC name="occupiedArea" title="公司占地面积" required="false" label="公司占地面积" labelCol="2" fieldCol="2"/>
                            <x:inputC name="capacity" title="生产能力" label="生产能力" required="false" labelCol="2" fieldCol="2"/>
                            <x:inputC name="totalEmployees" title="公司总人数" required="false" label="公司总人数" labelCol="2" fieldCol="2"/>
                        </div>
                        <div class="hg-form-row">
                            <x:inputC name="managementPersons" title="管理总人数" required="false" label="管理总人数" labelCol="2" fieldCol="2"/>
                            <x:inputC name="qcPersons" title="品管总人数" label="品管总人数" required="false" labelCol="2" fieldCol="2"/>
                        </div>
                        <div class="hg-form-row">
                            <x:hidden name="businessLicense" />
                            <x:hidden name="taxLicense" />
                            <div style="display: flex; margin-top:10px;">
                                <div>
                                    <img src='<c:url value="/images/photo.jpg"/>' height='144' width='102' border=0 id="showBusinessLicensePicture" onerror="src='<c:url value="/images/photo.jpg"/>';"/>
                                    <div style="text-align: center;margin-top:20px;">
                                        <x:button value="公司营业执照" id="addBusinessLicense" icon="fa-hand-o-up"/>
                                    </div>
                                </div>
                                <div style="margin-left: 30px">
                                    <img src='<c:url value="/images/photo.jpg"/>' height='144' width='102' border=0 id="showTaxLicensePicture" onerror="src='<c:url value="/images/photo.jpg"/>';"/>
                                    <div style="text-align: center;margin-top:20px;">
                                        <x:button value="税务登记证" id="addTaxLicense" icon="fa-hand-o-up"/>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="hg-form-row">
                            <x:textareaC name="mainProducts" title="公司主要产品" required="false" label="公司主要产品" labelCol="2" fieldCol="10" rows="3"/>
                        </div>
                        <div class="hg-form-row">
                            <x:checkboxListC name="managementSystemCertifications" dictionary="managementSystemCertifications"  title="取得何种管理体系认证" required="false" label="取得何种管理体系认证" labelCol="2" fieldCol="10"/>
                        </div>
                        <div class="hg-form-row">
                            <x:textareaC name="comprehensiveAssessment1" title="综合评价" label="综合评价" required="false" labelCol="2" fieldCol="10" rows="3"/>
                        </div>
                        <div class="hg-form-row">
                            <x:textareaC name="productionTestMachines" title="生产及检测设备" label="生产及检测设备" required="false" labelCol="2" fieldCol="10" rows="3"/>
                        </div>
                        <div class="hg-form-row">
                            <x:textareaC name="productionCapacity" title="生产能力" label="生产能力" required="false" labelCol="2" fieldCol="10" rows="3"/>
                        </div>
                        <div class="hg-form-row">
                            <x:textareaC name="deliverCapacity" title="交货能力" label="交货能力" required="false" labelCol="2" fieldCol="10" rows="3"/>
                        </div>
                        <div class="hg-form-row">
                            <x:textareaC name="agentRightsBrands" title="代理资格及代理品牌" required="false" label="代理资格及代理品牌" labelCol="2" fieldCol="10" rows="3"/>
                        </div>
                        <div class="hg-form-row">
                            <x:inputC name="sampleEvaluationResult" title="样品的评估结果" required="false" label="样品的评估结果" labelCol="2" fieldCol="4"/>
                            <x:inputC name="deptEvaluator1" title="部门/评估人" required="false" label="部门/评估人" labelCol="2" fieldCol="4"/>
                        </div>
                        <div class="hg-form-row">
                            <x:inputC name="priceReasonability" title="单价及合理性" required="false" label="单价及合理性" labelCol="2" fieldCol="4"/>
                            <x:inputC name="deptEvaluator2" title="部门/评估人" required="false" label="部门/评估人" labelCol="2" fieldCol="4"/>
                        </div>
                        <div class="hg-form-row">
                            <x:textareaC name="comprehensiveAssessment" title="综合评估" required="false" label="综合评估" labelCol="2" fieldCol="10" rows="3"/>
                        </div>
                        <div class="hg-form-row">
                            <x:radioC name="isTrialForMonth" title="是否试用月份" dictionary="yesorno" required="false" label="是否试用月份" labelCol="2" fieldCol="2"/>
                            <x:inputC name="trialForMonth" title="试用月份数量" required="false" label="试用月份数量" labelCol="2" fieldCol="2"/>
                            <x:radioC name="isOnsiteAudit" title="是否安排实地考察" dictionary="yesorno" required="false" label="是否安排实地考察" labelCol="2" fieldCol="2"/>
                            <x:radioC name="isApprovedSupplier" title="是否录入合格供方" dictionary="yesorno" required="false" label="是否录入合格供方" labelCol="2" fieldCol="2"/>
                        </div>
                        <div class="hg-form-row">
                            <x:fileList bizCode="produceSupplierInfo" bizId="attbizId" id="produceSupplierInfoList" title="相关资料" />
                        </div>
                    </div>
                </div>
                <div class="layout">
                    <div id="newSupplierReviewInfo" style="margin: 2px;">
                        <%--<jsp:include page="newSupplierReviewInfo.jsp"/>--%>
                        <x:hidden name="produceSupplierReviewId"/>
                        <div class="hg-form-row">
                            <x:inputC name="name" title="供应商名称" required="false" readonly="true" label="供应商名称" labelCol="2" fieldCol="6"/>
                            <x:inputC name="productNameAndType" title="产品名称及类别" required="false" label="产品名称及类别" labelCol="2" fieldCol="2"/>
                        </div>
                        <div class="hg-form-row">
                            <x:inputC name="address" title="公司地址" label="公司地址" readonly="true" required="false" labelCol="2" fieldCol="6"/>
                            <x:inputC name="reviewDate" title="评审日期" required="false"  label="评审日期" labelCol="2" fieldCol="2" wrapper="date"/>
                        </div>
                        <div class="hg-form-row">
                            <x:inputC name="businessContact" title="联系人" label="联系人" readonly="true" required="false" labelCol="2" fieldCol="2"/>
                            <x:inputC name="tel" title="联系电话" required="false" readonly="true" label="联系电话" labelCol="2" fieldCol="2"/>
                            <x:inputC name="fax" title="传真号码" required="false" readonly="true" label="传真号码" labelCol="2" fieldCol="2"/>
                        </div>

                        <div class="blank_div clearfix"></div>
                        <x:title title="一、品管评估项目：" name="group"/>
                        <p>1.品质管理体系：</p>
                        <div id="quality"></div>
                        <div class="blank_div clearfix"></div>
                        <p>2.文件控制：</p>
                        <div id="file" style="margin: 2px;"></div>
                        <div class="blank_div clearfix"></div>
                        <p>3.供应商品质控制：</p>
                        <div id="supplier" style="margin: 2px;"></div>
                        <div class="blank_div clearfix"></div>
                        <p>4.产品质量控制：</p>
                        <div id="product" style="margin: 2px;"></div>
                        <div class="blank_div clearfix"></div>
                        <p>5.不合格品控制：</p>
                        <div id="unqualified" style="margin: 2px;"></div>
                        <div class="blank_div clearfix"></div>
                        <p>6.产品的标识与追溯性控制：</p>
                        <div id="mark" style="margin: 2px;"></div>
                        <div class="blank_div clearfix"></div>
                        <p>7.量测仪器管制：</p>
                        <div id="measure" style="margin: 2px;"></div>
                        <div class="blank_div clearfix"></div>
                        <p>8.产品包装与防护：</p>
                        <div id="package" style="margin: 2px;"></div>
                        <div class="hg-form-row">
                            <x:inputC name="qualitySum" title="总得分" label="总得分" required="false" readonly="true" labelCol="2" fieldCol="2"/>
                            <x:inputC name="qualityTotal" title="品质得分=（总得分/110）*100" label="品质得分=（总得分/110）*100" required="false" readonly="true"  labelCol="2" fieldCol="2"/>
                            <x:inputC name="qualityReview" title="稽核人/日期：" label="稽核人/日期：" required="false" labelCol="2" fieldCol="2"/>
                        </div>
                        <div class="blank_div clearfix"></div>
                        <x:title title="二、工程评估项目：" name="group"/>
                        <p>1.生产设备及工治具评估：</p>
                        <div id="device" style="margin: 2px;"></div>
                        <div class="blank_div clearfix"></div>
                        <p>2.工程变更管制：</p>
                        <div id="change" style="margin: 2px;"></div>
                        <div class="blank_div clearfix"></div>
                        <p>3.产能评估：</p>
                        <div id="produce" style="margin: 2px;"></div>
                        <div class="hg-form-row">
                            <x:inputC name="projectSum" title="总得分" label="总得分" required="false" readonly="true" labelCol="2" fieldCol="2"/>
                            <x:inputC name="projectTotal" title="工程评分=（总得分/18）*100" label="工程评分=（总得分/18）*100" required="false" readonly="true"  labelCol="2" fieldCol="2"/>
                            <x:inputC name="projectReview" title="稽核人/日期：" label="稽核人/日期：" required="false" labelCol="2" fieldCol="2"/>
                        </div>
                        <div class="blank_div clearfix"></div>
                        <x:title title="三、采购评估项目：" name="group"/>
                        <p>1.价格评估：</p>
                        <div id="price" style="margin: 2px;"></div>
                        <div class="blank_div clearfix"></div>
                        <p>2.交期评估：</p>
                        <div id="giveDate" style="margin: 2px;"></div>
                        <div class="blank_div clearfix"></div>
                        <p>3.付款周期评估：</p>
                        <div id="payDate" style="margin: 2px;"></div>
                        <div class="hg-form-row">
                            <x:inputC name="purchaseSum" title="采购评分=以上三项目总和/3=" label="采购评分=以上三项目总和/3=" required="false" readonly="true" labelCol="2" fieldCol="2"/>
                        </div>
                        <div class="blank_div clearfix"></div>
                        <div class="blank_div clearfix"></div>
                        <div class="hg-form-row">
                            <x:inputC name="finalSum" title="最终得分=品管评分*35%+工程评分子量35%+采购评分*30%=" label="最终得分=品管评分*35%+工程评分子量35%+采购评分*30%=" required="false" readonly="true" labelCol="4" fieldCol="2"/>
                        </div>
                        <div class="hg-form-row">
                            <x:checkboxListC name="finalResult" dictionary="finalResult"  title="最终评审结果" required="false" label="最终评审结果" labelCol="2" fieldCol="10"/>
                        </div>
                        <div class="hg-form-row">
                            <x:checkboxListC name="finalReviewDealResult" dictionary="finalReviewDealResult"  title="最终评审处理决定" required="false" label="最终评审处理决定" labelCol="2" fieldCol="10"/>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
</body>
</html>
