var itemNumberGridManager = null, refreshFlag = false;
$(document).ready(function () {
    initUI();
    loadItemNumberGrid();
    }
);

function initUI() {
    UICtrl.initDefaultLayout();
}

function loadItemNumberGrid() {
    var toolbarOptions = null;
    toolbarOptions = UICtrl.getDefaultToolbarOptions({
        // 添加一行表格
        addHandler: function () {UICtrl.addGridRow(itemNumberGridManager)},
        // 删除
        deleteHandler: function () {
            var _grid = UICtrl.getGridManager('#itemNumberGrid');
            DataUtil.delSelectedRows({
                action: 'processQuotedPrice/deleteProcessQuotedPriceItemNumber.ajax',
                param: {},
                gridManager: _grid,
                idFieldName: 'id',
                onSuccess: function () {
                    itemNumberGridManager.loadData();
                }
            });
        }
    });
    // 表格
    itemNumberGridManager = UICtrl.grid("#itemNumberGrid", {
        gridManager: null,
        columns: [
            {
                display: "数量起", name: "numberFrom", width: 100, minWidth: 60, type: "String", align: "left",
                editor: {required: false, type: "text",mask: '999999999.99'}
            },
            {
                display: "数量止", name: "numberTo", width: 100, minWidth: 60, type: "String", align: "left",
                editor: {
                    required: false, type: "text",mask: '999999999.99'
                }
            },
            {
                display: "数量区间", name: "numberSection", width: 200, minWidth: 60, type: "String", align: "left",
                render: function (item){
                    return item.numberFrom + "<"+"数量"+(Public.isBlank(item.numberTo) ? "" : "<="+item.numberTo)
                }
            },
            {
                display: "备注", name: "remark", width: 200, minWidth: 60, type: "String", align: "left",
                editor: {
                    required: false, type: "text"
                }
            },
            {
                display: "价格单位", name: "priceUnit", width: 100, minWidth: 60, type: "String", align: "left",
                editor: {
                    required: true, type: "text",mask: '9999999'
                }
            },
            {
                display: "含税单价", name: "unitPrice", width: 100, minWidth: 60, type: "String", align: "left",
                editor: {
                    required: true, type: "text",mask: '9999999.999'
                }
            },
            {
                display: "税码", name: "purchaseMwskzTextView", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: 'dictionary',
                    data: {name: 'purchaseMwskz'},
                    textField: 'purchaseMwskzTextView',
                    valueField: 'purchaseMwskz',
                    required: true,
                    render: function (item) {
                        return item.purchaseMwskzTextView;
                    }
                },
            },
            {
                display: "不含税单价", name: "excludeTaxPrice", width: 100, minWidth: 60, type: "String", align: "left",
                editor: {
                    required: false, type: "text",mask: '9999999.999'
                }
            },
            {
                display: "运输费", name: "freight", width: 100, minWidth: 60, type: "String", align: "left",
                editor: {
                    required: false, type: "text",mask: '9999999.999'
                }
            },
            {
                display: "包装费", name: "packMoney", width: 100, minWidth: 60, type: "String", align: "left",
                editor: {
                    required: false, type: "text",mask: '9999999.999'
                }
            },
            {
                display: "最低消费", name: "minimum", width: 100, minWidth: 60, type: "String", align: "left",
                editor: {
                    required: false, type: "text",mask: '9999999.999'
                }
            },
            {
                display: "loss数(%)", name: "lossNumber", width: 100, minWidth: 60, type: "String", align: "left",
                editor: {
                    required: false, type: "text",mask: '9.99'
                }
            },
        ],
        dataAction: "server",
        url: web_app.name + '/processQuotedPrice/queryProcessQuotedPriceItemNumbers.ajax',
        parms: {processQuotedPriceItemId: $("#itemId").val()},
        pageSize: 10,
        usePager: true,
        sortName: "numberFrom",
        sortOrder: "asc",
        toolbar: toolbarOptions,
        enabledEdit: canEdit,
        width: "98%",
        height: "300px",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
    });
    UICtrl.setSearchAreaToggle(itemNumberGridManager);
}

function reloadItemNumberGrid() {
    itemNumberGridManager.loadData();
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(itemNumberGridManager, param);
}

function resetForm(obj) {
    $(obj).formClean();
}

