var gridManager = null;

$(document).ready(function () {
    initializateUI();
    loadCostCenterListGrid();
    bindEvent();
});


function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function loadCostCenterListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            addHandler();
        },
        // updateHandler: function () {
        //     updateHandler();
        // },
        // deleteHandler: deleteHandler,
    });
    gridManager = UICtrl.grid("#sapFixedAssetsListGrid", {
        columns: [
            {display: "BPM单号", name: "zfibpmnr", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "创建标识", name: "zfiflg", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "主资产号", name: "anln1", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "资产分类", name: "anlkl", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "资产分类描述", name: "anlklName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "公司代码", name: "bukrs", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "公司描述", name: "bukrsName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "文本", name: "txt50", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "规格型号", name: "txa50", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "存货号", name: "invnr", width: 140, minWidth: 60, type: "string", align: "left"},
            //{display: "数量", name: "menge", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "基本计量单位", name: "meins", width: 60, minWidth: 60, type: "string", align: "left"},
            {display: "基本计量单位描述", name: "meinsName", width: 60, minWidth: 60, type: "string", align: "left"},
            {display: "成本中心", name: "kostl", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "成本中心名称", name: "kostlName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "责任成本中心", name: "kostlv", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "责任成本中心名称", name: "kostlvName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "使用情况", name: "ord41TextView", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "取得方式", name: "ord42TextView", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "填报日期", name: "fillinDate", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "流程状态", name: "statusTextView", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "人员名称", name: "personMemberName", width: 140, minWidth: 60, type: "string", align: "left"},
            //{display: "消息类型", name: "type", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "消息文本", name: "message", width: 200, minWidth: 60, type: "string", align: "left"},

        ],
        dataAction: "server",
        url: web_app.name + '/sapFixedAssets/slicedFixedAssetsList.ajax',
        pageSize: 20,
        usePager: true,
        sortName: 'fillinDate',
        sortOrder: 'desc',
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        // 双击执行
        onDblClickRow: function (data, rowindex, rowobj) {
            updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'sapFixedAssetsDetail',
        text: "新增固定资产",
        url: web_app.name + '/sapFixedAssets/addFixedAssetsDetail.job'
    })
}

function updateHandler(row) {
    if (!row) {
        row = DataUtil.getUpdateRow(gridManager);
        if (!row) {
            return;
        }
    }
    UICtrl.addTabItem({
        tabid: 'FixedAssetsDetail'+ row.id,
        text: "查看固定资产",
        url: web_app.name + '/sapFixedAssets/showFixedAssetsDetail.job?isReadOnly=true&id='+row.id
    })
}

//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'sapFixedAssets/deleteCostCenterById.ajax',
        gridManager: gridManager, idFieldName: 'id',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

function bindEvent(){
    $('#anlkl').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "ANLKL"}
        },
        onChange: function (value, data) {
            $('#anlkl').val(data.ANLKL);
        }
    });
}

