<%@ page language="java" contentType="text/html; charset=utf-8" %>
<%@taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <x:base include="layout,dialog,grid,tree,dateTime,combox,attachment,commonTree,comboDialog"/>
    <script src='<c:url value="/lib/jquery/jquery.comboDialog.js"/>' type="text/javascript"></script>
    <script src='<c:url value="/lib/jquery/jquery.commonTree.js"/>' type="text/javascript"></script>
    <script src='<c:url value="/lib/jquery/jquery.flexField.js"/>' type="text/javascript"></script>
    <script src='<c:url value="/biz/topsun/sap/exceptionReport/exceptionReportList.js"/>' type="text/javascript"></script>
</head>
<body>
<div class="container-fluid">
    <div id="layout">
        <div position="center" title="">
            <x:title title="搜索" hideTable="queryMainForm"/>
            <form class="hg-form ui-show" method="post" action="" id="queryMainForm">
                <div class="hg-form-row">
                    <x:inputC name="billCode" label="报告编号" labelCol="1"/>
                    <x:inputC name="startDate" label="呈报开始日期" wrapper="dateTime" labelCol="1" />
                    <x:inputC name="endDate" label="呈报结束日期" wrapper="dateTime" labelCol="1" />
                    <x:inputC name="customerName" label="客户名称" labelCol="1"/>
                    <x:inputC name="customerOrderNo" label="客户单号" labelCol="1"/>
                    <x:inputC name="personMemberName" label="创建人" labelCol="1"/>
                    <x:inputC name="fillinDateStart" label="录入开始日期" wrapper="dateTime" labelCol="1" />
                    <x:inputC name="fillinDateEnd" label="录入结束日期" wrapper="dateTime" labelCol="1" />
                    <x:selectC name="exceptionType" label="异常类型" labelCol="1" dictionary="exceptionType"/>
                    <x:selectC name="exceptionReasonType" label="原因分类" labelCol="1" dictionary="exceptionReasonType"/>
                    <x:inputC name="reasonTypeDetailName" label="异常问题类型" labelCol="1"/>
                    <x:inputC name="produceNo" label="生产单号/采购" labelCol="1"/>
                    <x:inputC name="exceptionDateStart" label="异常开始日期" wrapper="dateTime" labelCol="1" />
                    <x:inputC name="exceptionDateEnd" label="异常结束日期" wrapper="dateTime" labelCol="1" />
                    <x:inputC name="productCode" label="产品/原料编码" labelCol="1"/>
                    <x:inputC name="brandName" label="品牌名称" labelCol="1"/>
                    <x:inputC name="productTypeName" label="产品类别" required="false" labelCol="1" fieldCol="2" wrapper="select"/>
                    <x:inputC name="checkOperatorName" label="责任人" labelCol="1"/>
                    <x:inputC name="dutyDeptName" label="责任部门" labelCol="1"/>
                    <x:selectC name="urgency" label="紧急程度" labelCol="1" fieldCol="2" dictionary="urgency"/>
                    <x:inputC name="problemTimes" label="问题发生次数" labelCol="1"/>
                    <x:checkboxListC name="needImproveReport" list="needImproveReportList"  label="客户是否需要改善报告" labelCol="1" fieldCol="1"/>
                    <x:checkboxListC name="needGuarantee" list="needGuaranteeList"  label="客户是否需要保证书" labelCol="1" fieldCol="1"/>
                    <x:checkboxListC name="statusKind" label="common.field.status" list="statusKindsList" labelCol="1" fieldCol="3"/>

                </div>
                <x:searchButtons/>
            </form>
            <x:title title="品质异常报告" hideTable="#maingrid" name="list"/>
            <div id="maingrid" style="margin:2px;"></div>
        </div>
    </div>
</div>
</body>
</html>

