var gridManager = null;

$(document).ready(function () {
    initUI();
    loadGrid();
})
function initUI() {
    UICtrl.initDefaultLayout();
    $('#werksName').searchbox({
        type: "system", name: "dictionary",
        getParam: function (item) {
            return {fieldName: "WERKS"}
        },
        onChange: function (value, data) {
            $('#werks').val(data.WERKS);
            $('#werksName').val(data.NAME1);
        }
    });
}


function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: addHandler,
        deleteHandler: deleteHandler,
        finishedHandler: {
            id: 'finishedHandler', text: '已处理', img:'fa-clipboard', click: function(){
                finished();
            }
        },

    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {display: "单据编号", name: "billCode", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "创建日期", name: "fillinDate", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请状态", name: "statusTextView", width: 60, minWidth: 60, type: "string", align: "left"},
            {display: "创建人", name: "personMemberName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "申请部门", name: "deptName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "工厂编码", name: "werks", width: 150, minWidth: 60, type: "string", align: "left"},
            {display: "工厂名称", name: "werksName", width: 220, minWidth: 60, type: "string", align: "left"},
          //  {display: "物料编码", name: "matnr", width: 100, minWidth: 60, type: "string", align: "left"},
          //  {display: "物料名称", name: "matnrName", width: 200, minWidth: 60, type: "string", align: "left"},
          //  {display: "批次", name: "batch", width: 120, minWidth: 60, type: "string", align: "left"},
         //   {display: "呆滞天数", name: "dullDays", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "说明", name: "remark", width: 220, minWidth: 60, type: "string", align: "left"},
            {display: "是否已处理", name: "isFinishedTextView", width: 100, minWidth: 60, type: "string", align: "left"}

        ],
        dataAction: "server",
        url: web_app.name + '/sapDull/slicedSapDullList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id);
        },
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}


//删除按钮
function deleteHandler() {
    let result=DataUtil.getUpdateRow(gridManager);
    if(result.status!==0){
        Public.tip("请选择申请状态的数据！")
        return false;
    }

 //   var message = "您确认要删除选择的数据?";
   // UICtrl.confirm(message, function () {
        DataUtil.del({
            action: 'sapDull/deleteSapDull.ajax',
            gridManager: gridManager, idFieldName: 'id',
            onSuccess: function () {
                reloadGrid();
            }
        });
   // });

}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'addSapDull',
        text: "呆滞物料",
        url: web_app.name + '/sapDull/forwardSapDullDetail.job'
    });
}

function doView(id) {
    UICtrl.addTabItem({
        tabid: 'viewSapDull'+id,
        text: "呆滞物料",
        url: web_app.name + '/sapDull/showDull.job?bizId='+id+"&isReadOnly=true"
    });
}

function finished(){
    var result = DataUtil.getSelectedRow(gridManager);
    if (!result) {
        return;
    }
    if(result.status!==3){
        Public.tip("请选择一条已审核后数据！")
        return false;
    }
    Public.ajax(web_app.name+'/sapDull/updateStatus.ajax',{id:result.id,status:"1"},function (data){
        reloadGrid();
    })

}

