var gridManager = null,refreshFlag = null;

$(document).ready(function () {
    initializateUI();
    loadCostCenterListGrid();
});


function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function loadCostCenterListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            addHandler();
        },
        impExcelDataHandler:{id:'impExcelData',img:'fa-table',text:'导入数据',click:impExcelDataHandler},
        updateHandler: function () {
            updateHandler();
        },
        deleteHandler: deleteHandler,
        // disableHandler: disableHandler,
        frozenHandler: {
            id: 'frozenHandler', text: '冻结', img: 'fa-clipboard', click: function () {
                var row = DataUtil.getUpdateRow(gridManager);
                if (!row) {
                    return;
                }
                if (row.isEnable == 0){
                    Public.errorTip("该成本中心已冻结，不能重复操作");
                    return;
                }
                UICtrl.addTabItem({
                    tabid: 'CostCenterDetail',
                    text: "冻结成本中心",
                    url: web_app.name + '/sapCostCenter/showFrozenCostCenterDetail.job?id=' + row.id
                })
            }
        }
    });
    gridManager = UICtrl.grid("#sapCostCenterListGrid", {
        columns: [
            {display: "成本中心编码", name: "kostl", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "名称", name: "ktext", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "描述", name: "ltext", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "成本中心类型", name: "kosarTextView", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "有限期自", name: "datbi", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "有限截止日", name: "datab", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "负责人", name: "verak", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "层次结构范围", name: "khinr", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "利润中心", name: "prctrTextView", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "申请人", name: "personMemberName", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "申请部门", name: "deptName", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "联系方式", name: "telePhone", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "申请日期", name: "fillinDate", width: 140, minWidth: 60, type: "date", align: "left"},
            {display: "原因", name: "reason", width: 140, minWidth: 60, type: "string", align: "left"},
            {
                display: "状态", name: "statusTextView", width: 60, minWidth: 60, type: "string", align: "center",
                // render: function (item) {
                //     return UICtrl.getStatusInfo(item.isEnable);
                // }
            },
            {display: "消息类型", name: "typeTextView", width: 140, minWidth: 60, type: "string", align: "left"},
            //{display: "消息编号", name: "number", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "消息文本", name: "message", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "是否历史数据", name: "isCostCenterHisTextView", width: 200, minWidth: 60, type: "string", align: "left"},
            //{display: "应用程序日志", name: "logNo", width: 140, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/sapCostCenter/slicedCostCenterList.ajax',
        pageSize: 20,
        usePager: true,
        sortName: 'fillinDate',
        sortOrder: 'desc',
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        // 双击执行
        onDblClickRow: function (data, rowindex, rowobj) {
            viewHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

function addHandler() {
    UICtrl.addTabItem({
        tabid: 'sapCostCenterDetail',
        text: "新增成本中心",
        url: web_app.name + '/sapCostCenter/addCostCenterDetail.job'
    })
}

//从EXCEL导入数据
function impExcelDataHandler(){
    ExcelImpManager.showImpDialog('导入', 'sapCostCenterData',new Date().getTime(), function (){
        reloadGrid();
    });
}

function viewHandler(data){
    UICtrl.addTabItem({
        tabid: data.id,
        text: "查看成本中心",
        url: web_app.name + '/sapCostCenter/showCostCenter.job?isReadOnly=true&bizId='+data.id
    })
}

function updateHandler(row) {
    if (!row) {
        row = DataUtil.getUpdateRow(gridManager);
        if (!row) {
            return;
        }
    }
    if (row.isCostCenterHis != 1){
        Public.tip("只能修改历史数据")
        return false;
    }
    UICtrl.showAjaxDialog({
        url: web_app.name + '/sapCostCenter/showLoadCostCenterHis.load',
        param:{id:row.id},
        title: "编辑功能",
        width: 800,
        ok: function doSaveNodeFunction(div){
            var _self=this;
            $('#submitForm').ajaxSubmit({
                url : web_app.name + '/sapCostCenter/saveCostCenter.ajax',
                success : function() {
                    refreshFlag = true;
                    _self.close();
                    reloadGrid();
                }
            });
        },
        //关闭对话框
        close:function dialogClose(){
            if(refreshFlag){
                refreshFlag=false;
            }
        },
    });
}

//删除按钮
function deleteHandler() {
    let row = DataUtil.getSelectedRow(gridManager);
    //只能删除历史数据和新增已中止数据
    if (row.isCostCenterHis != 1 && row.status != 5){
        Public.tip("只能删除已中止数据");
        return false;
    }
    DataUtil.del({
        action: 'sapCostCenter/deleteCostCenterById.ajax',
        gridManager: gridManager, idFieldName: 'id',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

// 冻结按钮
function disableHandler() {
    DataUtil.updateById({
        action: 'sapCostCenter/updateCostCenterStatus.ajax',
        gridManager: gridManager, idFieldName: 'id', param: {status: 0},
        message: 'common.confirm.disable',
        onSuccess: function () {
            reloadGrid();
        }
    });
}
