var gridManager = null;

$(document).ready(function () {
    initUI();
    loadGrid();
})
function initUI() {
    UICtrl.initDefaultLayout();

}


function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: addHandler,
        exportExcelHandler: function(){
            UICtrl.gridExport(gridManager);
        },

    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {display: "单据状态", name: "statusTextView", width: 60, minWidth: 60, type: "string", align: "left"},
            {display: "收款状态", name: "payStatus", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "单据编号", name: "billCode", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "客户", name: "customerName", width: 200, minWidth: 60, type: "string", align: "left"},
            {display: "金额", name: "amount", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "理由", name: "reason", width:200, minWidth: 60, type: "string", align: "left"},
            {display: "录入人", name: "personMemberName", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "录入日期", name: "fillinDate", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "修改人", name: "updatePersonName", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "修改日期", name: "updateDate", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "审核人", name: "approvalName", width: 100, minWidth: 60, type: "string", align: "left"},
            {display: "审核日期", name: "approvalDate", width: 100, minWidth: 60, type: "string", align: "left"},

        ],
        dataAction: "server",
        url: web_app.name + '/cashSettlementUnPay/slicedCashSettlementUnPayList.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.id);
        },
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}
function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}
function addHandler() {
    UICtrl.addTabItem({
        tabid: 'addCashSettlementUnPay',
        text: "新增现结未付款先发货申请",
        url: web_app.name + '/cashSettlementUnPay/forwardCashSettlementUnPayDetail.job'
    });
}

function doView(id) {
    UICtrl.addTabItem({
        tabid: 'viewCashSettlementUnPay'+id,
        text: "查看现结未付款先发货申请",
        url: web_app.name + '/cashSettlementUnPay/showCashSettlementUnPay.job?bizId='+id+"&isReadOnly=true"
    });
}


