<%@ page language="java" contentType="text/html; charset=utf-8" %>
<%@taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <x:base include="layout,dialog,grid,tree,dateTime,combox,attachment,commonTree,comboDialog"/>
    <x:script src='/biz/topsun/mes/unqualifiedMaterials/unqualifiedMaterialsDetail.js'/>
</head>
<body>
<div class="container-fluid">
    <x:billTitle title="质量异常评审表" needStatus="false" needPerson="true"/>
    <form class="hg-form" method="post" action="" id="submitForm">
    <x:hidden name="id"/>
    <x:hidden name="billCode"/>
    <x:hidden name="fillinDate" type="datetime"/>
    <x:hidden name="fullId"/>
    <x:hidden name="organId"/>
    <x:hidden name="organName"/>
    <x:hidden name="deptId"/>
    <x:hidden name="deptName"/>
    <x:hidden name="positionId"/>
    <x:hidden name="positionName"/>
    <x:hidden name="personMemberId"/>
    <x:hidden name="personMemberName"/>
    <x:hidden name="statusId"/>
    <x:hidden name="defaultResult"/>
    <x:hidden name="hasDecide"/>
    <div class="hg-form-cols">
        <div class="hg-form-row">
            <x:inputC name="mblnr" required="false" readonly="true" label="物料凭证号" labelCol="1" fieldCol="2"/>
            <x:inputC name="zeile" required="false" readonly="true" label="凭证项次" labelCol="1" fieldCol="2"/>
            <x:inputC name="mjahr" required="false" readonly="true" label="凭证年份" labelCol="1" fieldCol="2"/>
            <x:inputC name="type" required="false" readonly="true" label="类别" labelCol="1" fieldCol="2"/>
        </div>
        <div class="hg-form-row">
            <x:inputC name="productName" required="false" readonly="true" label="产品名称" labelCol="1" fieldCol="2"/>
            <x:inputC name="batchNo" required="false" readonly="true" label="生产批次" labelCol="1" fieldCol="2"/>
            <x:inputC name="purchaseOrderNo" required="false" readonly="true" label="采购单号" labelCol="1" fieldCol="2"/>
            <x:inputC name="orderType" required="false" readonly="true" label="订单类型" labelCol="1" fieldCol="2"/>
        </div>
        <div class="hg-form-row">
            <x:inputC name="pd" required="false" readonly="true" label="PD/YL编码" labelCol="1" fieldCol="2"/>
            <x:inputC name="quantity" required="false" readonly="true" label="订单数量" labelCol="1" fieldCol="2"/>
            <x:inputC name="exceptionNum" required="false" readonly="true" label="异常数量" labelCol="1" maxLength="64" fieldCol="2"/>
            <x:inputC name="process" required="false" readonly="true" label="部门/工序" labelCol="1" maxLength="64" fieldCol="2"/>
        </div>
        <div class="hg-form-row">
            <x:hidden name="dutyDept"/>
            <x:hidden name="submitter"/>
            <x:inputC name="vendorCode" required="false" readonly="true" label="供应商编码" labelCol="1" maxLength="64" fieldCol="2"/>
            <x:inputC name="vendorName" required="false" readonly="true" label="供应商名称" labelCol="1" maxLength="64" fieldCol="2"/>
            <x:inputC name="dutyDeptName" required="false" readonly="true" label="评审部门" labelCol="1" fieldCol="2" />
            <x:inputC name="usnam" required="false" readonly="true" label="收货人" labelCol="1" fieldCol="2" />
        </div>
        <div class="hg-form-row">
            <x:textareaC name="exceptionDesc" required="false" label="异常描述" labelCol="1" fieldCol="10" rows="3" readonly="true"/>
        </div>
        <div class="hg-form-row">
            <x:inputC name="submitterName" required="false" readonly="true" label="提报人" labelCol="1" fieldCol="2" />
            <x:selectC name="result" required="false" label="评审结果" labelCol="1" fieldCol="2" dictionary="result"/>
        </div>
    </div>
        <div style="padding-top: 15px;">
            <x:fileList bizCode="unqualifiedMaterials" bizId="id" id="fileList" title="相关资料" />
        </div>
</form>
</div>
</body>
</html>
