var gridManager = null;

$(document).ready(function () {
    initialize();
    loadGrid();
    bindEvent();
});
function initialize(){
    var orderTypeName = $("#orderTypeName").val();
    $('#jobBizBillBody .subject').html(orderTypeName);
    if  ($('#statusId').val()=="0") {
    } else {
       UICtrl.setDisable($("#submitForm"));
    }
    UICtrl.layout("#layout", {leftWidth: 3});
}

function bindEvent(){

}

function loadGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
    });
    gridManager = UICtrl.grid("#maingrid", {
        columns: [
            {
                display: "订单原因（业务交易原因）", name: "augru", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "订单编号", name: "vbeln", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "生产工单", name: "workorderCode", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "跟单员", name: "merchandiserName", width: 100, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "订单总金额", name: "amount", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "客户采购单号", name: "bstnk", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "销售凭证项目", name: "posnr", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "物料编号", name: "matnr", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "物料描述", name: "maktx", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "订单数量", name: "kwmeng", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "销售单位", name: "vrkme", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "价格", name: "vaKbetr", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "工厂", name: "werks", width: 200, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "指令号", name: "zinstnum", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "型体号", name: "zmold", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "配色号", name: "zmapcolor", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "品牌", name: "mvgr1", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },
            {
                display: "物料组", name: "matkl", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    type: "text"
                }
            },

        ],
        dataAction: "server",
        _tableKey: 'epSaleOrder',
        _local: true,
        url: web_app.name + '/epSaleOrderItem/queryEpSaleOrderItems.ajax',
        pageSize: 10,
        usePager: true,
        parms:{epSaleOrderId:getId()},
        toolbar: toolbarOptions,
        enabledEdit: false,
        width: "100%",
        height: "98%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

/**
 * 流程引擎回调设置打样的id
 * @param value 打样申请的id
 */
function setId(id) {
    $("#id").val(id);

    var _grid=UICtrl.getGridManager('#maingrid');
    _grid.options.parms.epSaleOrderId = id;
}

/**
 * 流程引擎获取打样申请id的回掉方法。
 * @return 打样申请的id
 */
function getId() {
    return $("#id").val() || "";
}

function reloadGrid() {
    gridManager.loadData();
}

function getExtendedData(processAction) {
//回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
//不验证
        $('#submitForm').attr('check', false);
    }
    var extendedData = {};
    var _grid = UICtrl.getGridManager('#maingrid');
    if (_grid) {
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: true
        });
        if (!datas) {
            return false;
        }
        extendedData.items = Public.encodeJSONURI(datas);
    }
    return extendedData;
}
