﻿<%@ page contentType="text/html; charset=utf-8"%>
<%@ page import="java.util.List,java.util.Map" %>
<%@ page import="com.huigou.context.ContextUtil" %>
<%@ page import="com.huigou.context.MessageSourceContext" %>
<%@ page import="com.huigou.cache.DictUtil" %>
<%@ page import="com.huigou.util.Constants" %>
<%@ page import="com.huigou.util.CommonUtil" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="/WEB-INF/taglib.tld" prefix="x"%>
<%@ taglib uri="/WEB-INF/JSTLFunction.tld" prefix="f"%>
<%
	String token = (String)ContextUtil.getSession().getAttribute(Constants.CSRF_TOKEN);
    if (token == null || token == ""){
        token = CommonUtil.createGUID();
        ContextUtil.getSession().setAttribute(Constants.CSRF_TOKEN, token);
    }
    MessageSourceContext.setLocale(request, response);
    List<Map<String, Object>> i18nLanguages=DictUtil.getDictionaryList("i18nLanguage");
	request.setAttribute("isI18nLanguage", false);
	if(i18nLanguages!=null&&i18nLanguages.size()>0){
	    request.setAttribute("isI18nLanguage", true);
		request.setAttribute("i18nLanguages", i18nLanguages);
	}
	response.setHeader("Pragma","No-cache");
	response.setHeader("Cache-Control","No-cache");
	response.setHeader("Cache-Control", "No-store");
	response.setDateHeader("Expires", 0);
%>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, maximum-scale=1, shrink-to-fit=no"/>
	<!--[if lt IE 8]>
	<meta http-equiv="refresh" content="0;url='ie.html'"/>
	<![endif]-->
	<title><c:out value="${f:systemParameter('SYSTEM.NAME')}" /></title>
	<x:link href="/themes/font-face.css"/>
	<x:base include="base,dialog,comboDialog" />
	<%--<x:base include="layout,dialog,grid,tree,dateTime,combox,attachment,monthpicker,echart" />--%>
	<x:link href="/login/css/login.css"/>
	<x:link href="/themes/extend.css"/>
	<!--[if lt IE 9]>
	<x:script src='/lib/bootstrap/html5shiv.min.js'/>
	<x:script src='/lib/bootstrap/respond.min.js'/>
	<![endif]-->
	<x:script src='/lib/jquery/jquery.base64.js'/>
	<x:script src='/lib/jquery/jquery.md5.js'/>
	<x:script src='/lib/jquery/jquery.aes.js'/>
	<x:script src='/login/js/Login.js'/>
	<style type="text/css">
	.footer{
		display: -webkit-box;
		display: -ms-flexbox;
		display: flex;
		-webkit-box-orient: vertical;
		-webkit-box-direction: normal;
		-ms-flex-direction: column;
		flex-direction: column;
		-ms-flex-wrap: wrap;
		flex-wrap: wrap;
		-webkit-box-pack: center;
		-ms-flex-pack: center;
		justify-content: center;
		-webkit-box-align: center;
		-ms-flex-align: center;
		
		color: #ffffff;
	}
	#login-left {
		float: right;
		width: 418px;
		height: 420px;
		/* background: url(login/images/bg.jpg) no-repeat center center; */
		background: none;
		margin-top: 60px;
	}
	#login-page .login-main {
		background: url(login/images/bg.jpg);
		background-size: cover;
		background-position: 10% 20%;
    	/* background-attachment: fixed; */
    	
    	position: absolute;
	    width: 100%;
	    top: 80px;
	    bottom: 0px;
	}
	.container {
		position: fixed;
	    top: 0px;
	    bottom: 0px;
	    left: 0px;
	    right: 0px;
	}
	#login-page .login-head {
		position: absolute;
		background: white;
		width: 100%;
		height: 80px;
	}
	#login-page .login-head img {
		display: inline-block;
		width: 150px;
	}

	.footerbg {
		/* background: rgba(0,0,0,.5); */
	    position: absolute;
	    top: 0px;
	    bottom: 0px;
	    left: 0px;
	    right: 0px;
	}
	#login-box-inner {
		padding: 20px 25px;
	}
	</style>
</head>
<body id="login-page" class="dom-overflow" style="background-color: #ffffff">
	<input type="hidden" id="csrfTokenElement" value="<%=token%>"/>
	<div class="container" style="width:100%;">
		<div class="row login-head hidden-xs">
			<c:if test="${f:systemParameter('SYSTEM.LOGO.PATH')!=null}">
				<img src="<c:url value="${f:systemParameter('SYSTEM.LOGO.PATH')}"/>" class=""/>
			</c:if>
		</div>
		<div class="row login-main">
			<div id="login-left" style="float: none; position: absolute; top: 70px; left: 0px; right: 0px; bottom: 0px; width: 100%; opacity: .7;"></div>
			<div class="col-sm-3 hidden-xs">
			</div>
			<div class="col-sm-6 col-xs-12">
				<div id="login-box" style="margin: 90px auto 60px; border-radius: 7px 7px 0 0;">
					<div id="login-box-holder">
						<div class="row">
							<div class="col-xs-12">
								<div id="login-header">
									<div id="login-logo" style="background: #ffffff; color: #323232; padding: 25px 0;">
										<!-- <i class="fa fa-joomla"></i>&nbsp; -->
										<c:out value="${f:systemParameter('SYSTEM.NAME')}" />
									</div>
								</div>
								<div id="login-box-inner" style="border: 0px; padding-top: 5px; border-radius: 0 0 7px 7px;">
									<form role="form" action=""  name="logonForm" id="logonForm">
										<div class="input-group">
											<span class="input-group-addon"><i class="fa fa-user"></i></span>
											<input class="text" type="text" id="userName" name="userName"/>
										</div>
										<div class="input-group">
											<span class="input-group-addon"><i class="fa fa-key"></i></span>
											<input type="password" class="text" id="password" name="password" autocomplete="off"/>
										</div>
										<c:if test="${f:systemParameter('verify.code.image')=='true'}">
										<div class="input-group">
			                                <input type="text" class="text" id="verifyCode" name="verifyCode" autocomplete="off"/>
			                                <span class="input-group-addon">
			                                   <img src="<c:url value="/verifycode.load"/>" height="40" id="verifyCodeImg" title="点击更换图片"/>
			                                </span>
			                            </div>
										</c:if>
										<div id="remember-me-wrapper">
											<div class="row">
												<div class="col-xs-6">
													<div class="checkbox-nice">
														<input type="checkbox" name="remember" id="remember"/>
														<label for="remember"><x:message key="common.Rememberme"/></label>
													</div>
												</div>
<%--												<div class="col-xs-6">--%>
<%--													<a href="#" id="forget">忘记密码？</a>--%>
<%--												</div>--%>
											</div>
										</div>
										<div class="row">
											<div class="col-xs-12">
											<label for="remember">系统支持：Chrome、微软Edge、Firfox、Safari、360（必须选择极速模式)浏览器</label>
											</div>
										</div>
										
										<div class="row">
											<div class="col-xs-12">
												<button type="button" class="btn btn-primary col-xs-12" id="btnLogin" name="button" >
													<x:message key="common.login"/>
												</button>
											</div>
										</div>
										
										
										<!--<c:if test="${isI18nLanguage}">
										<div class="row">
											<div class="col-xs-12 switch-language" style="text-align:center;padding-top:10px;">
												<c:forEach items="${i18nLanguages}" var="language" varStatus="i">
												<c:set var="languageClassName" value="btn-info" />
												<c:if test="${i.index%2==1}">
													<c:set var="languageClassName" value="btn-warning" />
												</c:if>
												<a class="btn btn-xs <c:out value="${languageClassName}"/>" href="javascript:void(0);" data-language="<c:out value="${language.value}"/>">
													<c:out value="${language.name}"/>
												</a>
						                       	</c:forEach>
						                     </div>
										</div>
										</c:if>-->
									</form>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-sm-3"></div>
		</div>
		<div class="row footer" style="position: fixed; height: 50px; left: 0px; right: 0px;bottom: 0px; text-align: center;">
			<div class="col-xs-12" style="z-index: -1;">
				<%--<c:out value="${f:systemParameter('SYSTEM.COPYRIGHT')}" escapeXml="false"/>--%>
			</div>
			<div class="col-xs-12" style="z-index: -1;">
				<%--<c:out value="${f:systemParameter('SYSTEM.RECORD.NO')}" escapeXml="false"/>--%>
				<a target="_blank" href="http://beian.miit.gov.cn" rel="noopener noreferrer" style="display:inline-block;text-decoration:none;height:20px;line-height:20px;">
					<p style="float:left;height:20px;line-height:20px;margin: 0px 0px 0px 5px; color:#939393;"><%--沪ICP备14026862号-2--%></p>
				</a>
				<a target="_blank" href="http://www.beian.gov.cn/portal/registerSystemInfo?recordcode=31011502019122" style="display:inline-block;text-decoration:none;height:20px;line-height:20px;">
					<%--<img src="<c:url value="/images/police-20230522.png"/>" style="float:left;"/>--%>
					<p style="float:left;height:20px;line-height:20px;margin: 0px 0px 0px 5px; color:#939393;"><%--沪公网安备 31011502019122号--%></p>
				</a>
			</div>
		</div>
	</div>
</body>
</html>