package com.huigou.topsun.syncOrg.application;

import com.huigou.topsun.syncOrg.vo.EpOrgVo;
import com.huigou.topsun.syncOrg.vo.OrgPersonVo;
import com.huigou.topsun.syncOrg.vo.PersonVo;
import com.huigou.topsun.syncOrg.vo.SapPersonVo.SapPersonVo;
import com.huigou.uasp.bmp.opm.domain.model.org.Org;
import com.huigou.uasp.bmp.opm.domain.model.org.Person;

import java.io.IOException;
import java.util.List;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/25/9:27
 * @Description:
 */
public interface OrgSyncApplication {
    /**
     * 查询文件配置地址
     */
    static final String QUERY_XML_FILE_PATH = "config/topsun/base/syncOrg.xml";

    /**
     * 构建机构、部门、岗位、人员VO类
     * @return
     */
    public EpOrgVo buildOrgVo ();

    /**
     * 构建组织人员对应关系
     * @param psmList
     * @return
     */
    public List<OrgPersonVo> buildOrgPersonVo(List<Org> psmList);

    /**
     * 构架人员
     * @param psmList
     * @return
     */
    public List<PersonVo> buildPersonVo(List<Org> psmList);

    /**
     * 同步SAP人员
     */
    public void syncPersonListToSap();

    /**
     * 同步SAP人员
     */
    public void syncPersonToSap(String flag,List<String> codes);

    /**
     * 构建SAP人员
     * @return
     */
    List<SapPersonVo> slicedSapPersonVoList();

    List<SapPersonVo> slicedSapPersonVo(List<String> codes);

    void buildSapPerson(String flag,List<SapPersonVo> sapPersonVoList);

    /**
     * 根据fullid模糊查询下属人员编码
     * @param fullId
     * @return
     */
    List<Person> queryPersonCodeByFullId(String fullId);


    List<SapPersonVo> querySapPersonVoByFullId(String fullId);

    void syncAllPersonToSap();

    List<String> getCodeById(List<String> personIds);
}
