package com.huigou.topsun.sap.suppliers.domain.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 
 * @TableName sap_suppliers_item_period
 * 供应商子范围
 */
@Data
public class SuppliersItemPeriodVo implements Serializable {

    /**
     * 采购组织
     */
    @JsonProperty("EKORG")
    private String ekorg;

    /**
     * 供应商子范围
     */
    @JsonProperty("LTSNR")
    private String ltsnr;

    /**
     * 供应商子范围描述
     */
    @JsonProperty("LTSBZ")
    private String ltsbz;

    /**
     * 工厂
     */
    @JsonProperty("WERKS")
    private String werks;

    /**
     * 工厂名称
     */
    @JsonProperty("NAME1")
    private String name1;

    /**
     * 货币码
     */
    @JsonProperty("WAERS")
    private String waers;

    /**
     * 付款条件代码
     */
    @JsonProperty("ZTERM")
    private String payCondition;

    /**
     * 国际贸易条款
     */
    @JsonProperty("INCO1")
    private String inco1;

    /**
     * 国际贸易条款位置 1
     */
    @JsonProperty("INCO2_L")
    private String inco2L;

    /**
     * 国际贸易条款位置 2
     */
    @JsonProperty("INCO3_L")
    private String inco3L;

    /**
     * 标识：基于收货的发票验证
     */
    @JsonProperty("WEBRE")
    private String webre;

    /**
     * 计算方案组（供应商）
     */
    @JsonProperty("KALSK")
    private String kalsk;


    /**
     * 供应商办公室的负责销售人员
     */
    @JsonProperty("VERKF")
    private String verkf;


    /**
     * 供应商电话号码
     */
    @JsonProperty("TELF1")
    private String telf1;

    /**
     * 基于服务的发票校验标识
     */
    @JsonProperty("LEBRE")
    private String lebre;

    /**
     * 边境运输方式（欧盟内部贸易统计）
     */
    @JsonProperty("EXPVZ")
    private String expvz;


    /**
     * 采购冻结在采购组织层
     */
    @JsonProperty("SPERM")
    private String sperm;
    
}