package com.huigou.topsun.sap.suppliers.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.common.BillStatus;
import com.huigou.topsun.sap.suppliers.application.SuppliersDataApplication;
import com.huigou.topsun.sap.suppliers.domain.SuppliersInfo;
import com.huigou.topsun.sap.suppliers.domain.query.SuppliersBankQueryRequest;
import com.huigou.topsun.sap.suppliers.domain.query.SuppliersBuyerQueryRequest;
import com.huigou.topsun.sap.suppliers.domain.query.SuppliersDataQueryRequest;
import com.huigou.topsun.sap.suppliers.domain.query.SuppliersPayQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 *
 * @Date: 2024/03/01
 * @Description:
 */
@Controller
@ControllerMapping("/sapSuppliersData")
public class SuppliersDataController extends CommonController {

    protected String getPagePath() {
        return "/biz/topsun/sap/suppliers/";
    }


    @Autowired
    SuppliersDataApplication suppliersDataApplication;

    @Autowired
    ImpDataFromXLS impDataFromXLS;


    public String forwardSuppliersDataList() {
        this.putAttribute("statusKindsList", BillStatus.getValidMap());
        return forward("suppliersDataList");
    }


    public String slicedSuppliersDataList() {
        SDO sdo = this.getSDO();
        SuppliersDataQueryRequest queryRequest = sdo.toQueryRequest(SuppliersDataQueryRequest.class);
        Map<String, Object> map = suppliersDataApplication.slicedSuppliersDataQuery(queryRequest);
        return toResult(map);
    }


    public String forwardSuppliersDataApply() {

       this.putAttribute("processDefinitionKey",SuppliersDataApplication.PROCESS_DEFINITION_KEY);
       this.putAttribute("procUnitId","Apply");//定义流程环节的id
       this.putAttribute("applyType","0");
        SDO sdo = this.getSDO();
        String bizId=sdo.getString("bizId");
        String flag=sdo.getString("flag");
        SuppliersInfo suppliersInfo = new SuppliersInfo();
        suppliersInfo.setApplyType("0");
        suppliersInfo.setSperr("0");
        suppliersInfo.setSperm("0");
        String isDel=sdo.getString("isDel");
        String page = "suppliersDataDetail";
        if (StringUtil.isNotBlank(isDel)){ //删除流程
            suppliersInfo = suppliersDataApplication.loadSuppliersDataById(bizId);
            this.putAttribute("processDefinitionKey", SuppliersDataApplication.PROCESS_DEFINITION_KEY3);
            this.putAttribute("applyType", "-1");
            suppliersInfo.setApplyType("-1");
            suppliersInfo.setBillCode("");
            suppliersInfo.setId("");
            // suppliersInfo.setSId(bizId);
            Map<String, Object> map = new HashMap();
            map.put("bizId", "");
            sdo.setProperties(map);
            suppliersInfo.setFullId("");
            this.putAttribute("bizId", "");
            this.putAttribute("sId", bizId);
            this.putAttribute("id", "");
        } else {
            if (StringUtil.isNotBlank(bizId)) {
                suppliersInfo = suppliersDataApplication.loadSuppliersDataById(bizId);

                sdo.putProperty("partner",suppliersInfo.getPartner());
                List deletedList=suppliersDataApplication.findDeletedSuppliersDataById(sdo);

                if (deletedList.size()>0){
                    throw new RuntimeException("该供应商已经执行删除，不能再次修改了！");
                }
                if ("update".equals(flag)){
                    this.putAttribute("processDefinitionKey", SuppliersDataApplication.PROCESS_DEFINITION_KEY2);
                    this.putAttribute("applyType", "1");
                    suppliersInfo.setApplyType("1");
                } else if ("extend".equals(flag)) {
                    this.putAttribute("processDefinitionKey", SuppliersDataApplication.PROCESS_DEFINITION_KEY4);
                    this.putAttribute("applyType", "2");//扩展
                    suppliersInfo.setApplyType("2");
                    page = "suppliersExtendDataDetail";
                }

                suppliersInfo.setBillCode("");
                suppliersInfo.setId("");
                // suppliersInfo.setSId(bizId);
                Map<String, Object> map = new HashMap();
                map.put("bizId", "");
                sdo.setProperties(map);
                suppliersInfo.setFullId("");
                this.putAttribute("bizId", "");
                this.putAttribute("sId", bizId);
                this.putAttribute("id", "");
            }else {
                suppliersInfo.setBanks("CN");
                suppliersInfo.setLand1("CN");
                suppliersInfo.setLand1Name("中国");
            }
        }
        suppliersInfo.setStatusId(BizBillStatus.APPLYING.getId());
        Operator operator = getOperator();//获取当前操作员的详情信息
        suppliersInfo.setDefaultValues(new OrgUnit(operator.getFullId(),operator.getFullName()));

        return  forward(page,suppliersInfo);
   }

    public String showSuppliersData() {
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        String isDetailPage = sdo.getString("isDetailPage");
        this.putAttribute("applyType","0");
        if("true".equals(isDetailPage)) this.putAttribute("isDetailPage","true");
        SuppliersInfo suppliersInfo = suppliersDataApplication.loadSuppliersDataById(id);
        if (!(suppliersInfo.getApplyType().equals("0"))){
            this.putAttribute("sId", id);
            this.putAttribute("applyType",suppliersInfo.getApplyType());
            if ("2".equals(suppliersInfo.getApplyType())){
                return forward("suppliersExtendDataDetail", suppliersInfo);
            }
        }
        return forward("suppliersDataDetail", suppliersInfo);
    }

    public String  slicedSuppliersPayData(){
        SDO sdo = this.getSDO();
        SuppliersPayQueryRequest queryRequest=sdo.toQueryRequest(SuppliersPayQueryRequest.class);
        queryRequest.setSId(sdo.getString("sId"));
        Map<String, Object> map = suppliersDataApplication.loadSuppliersPayDatas(queryRequest);
        return toResult(map);
     }

    public String slicedSuppliersBuyerData(){
        SDO sdo = this.getSDO();
        SuppliersBuyerQueryRequest queryRequest=sdo.toQueryRequest(SuppliersBuyerQueryRequest.class);
        queryRequest.setSId(sdo.getString("sId"));
        Map<String, Object> map = suppliersDataApplication.loadSuppliersBuyerDatas(queryRequest);
        return toResult(map);
    }

    public String  slicedSuppliersBankData(){
        SDO sdo = this.getSDO();
        SuppliersBankQueryRequest queryRequest=sdo.toQueryRequest(SuppliersBankQueryRequest.class);
        queryRequest.setSId(sdo.getString("sId"));
        Map<String, Object> map = suppliersDataApplication.loadSuppliersBankDatas(queryRequest);
        return toResult(map);
    }

    public String  slicedSuppliersItemPeriodData(){
        SDO sdo = this.getSDO();
        SuppliersBankQueryRequest queryRequest=sdo.toQueryRequest(SuppliersBankQueryRequest.class);
        queryRequest.setSId(sdo.getString("sId"));
        Map<String, Object> map = suppliersDataApplication.loadSuppliersItemPeriodDatas(queryRequest);
        return toResult(map);
    }

    public String deleteSuppliersData() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        suppliersDataApplication.deleteSuppliersDataByIds(ids);
        return success();
    }

    public String deleteSuppliersPays() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        suppliersDataApplication.deleteSuppliersPaysByIds(ids);
        return success();
    }

    public String deleteSuppliersBanks() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        suppliersDataApplication.deleteSuppliersBankByIds(ids);
        return success();
    }

    public String deleteSuppliersBuyers() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        suppliersDataApplication.deleteSuppliersBuyerByIds(ids);
        return success();
    }

    public String deleteSuppliersItemPeriods() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        suppliersDataApplication.deleteSuppliersItemPeriodByIds(ids);
        return success();
    }

    public String  importInitData(){
        SDO sdo = this.getSDO();
        impDataFromXLS.readFile();
        return success();
    }

    public String checkApprovalStatus(){
        SDO sdo = this.getSDO();
        String partner = sdo.getString("partner");
        suppliersDataApplication.checkApprovalStatus(partner);
        return success();
    }

    public String getSupplierNowItemList(){
        SDO sdo = this.getSDO();
        String partner = sdo.getString("partner");
        Map<String, String> map = suppliersDataApplication.getSupplierNowItemList(partner);
        return toResult(map);
    }
}
