package com.huigou.topsun.sap.sapApplication.application.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huigou.topsun.sap.common.HttpClient;
import com.huigou.topsun.sap.common.domain.SapResult;
import com.huigou.topsun.sap.sapApplication.application.SapPaymentApplication;
import com.huigou.topsun.util.SAPUtils;
import com.huigou.util.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/06/21:08
 * @Description:
 */
@Service("sapPaymentApplication")
public class SapPaymentApplicationImpl implements SapPaymentApplication {
    @Autowired
    private HttpClient httpClient;
    @Override
    public List<Map<String, String>> getCusAndSuppliers(String BUKRS, String ZEP_BPTYPE) throws IOException {
        Map<String,String> param = new HashMap<>();
        param.put("BUKRS",BUKRS);
        param.put("ZEP_BPTYPE",ZEP_BPTYPE);
        String execute = null;
        List<Map<String,String>> mapList = new ArrayList<>();
        try {
            execute = httpClient.execute(param, "search/sch_partner");
            Map<String, String> map = JSONObject.parseObject(execute, Map.class);
            SapResult sapResult = JSONObject.parseObject(JSONUtil.toJsonStr(map.get("MSG")), SapResult.class);
            if ("S".equals(sapResult.getTYPE())) {
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                mapList = objectMapper.readValue(com.huigou.util.JSONUtil.toString(map.get("RDATA")), new TypeReference<List<Map<String, String>>>() {});

                //mapList = (List<Map<String,String>>)JSONArray.parse(JSONUtil.toJsonStr(map.get("RDATA")));
            }
//            else {
//                throw new RuntimeException("客户、供应商失败：" + sapResult.getMESSAGE());
//            }
        } catch (IOException e) {
            throw new RuntimeException("查询客户、供应商出错”。");
        }
        return mapList;
    }

    @Override
    public List<Map<String, String>> getCusAndBanks(String PARTNER, String ZEP_BPTYPE) throws IOException {
        Map<String,Object> param = new HashMap<>();
        param.put("PARTNER",PARTNER);
        param.put("ZEP_BPTYPE",ZEP_BPTYPE);
        String execute = null;
        List<Map<String,String>> mapList = new ArrayList<>();
        try {
            execute = httpClient.execute(param, "search/sch_bankdata");
            Map<String, String> map = JSONObject.parseObject(execute, Map.class);
            SapResult sapResult = JSONObject.parseObject(JSONUtil.toJsonStr(map.get("MSG")), SapResult.class);
            if ("S".equals(sapResult.getTYPE())) {
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                mapList = objectMapper.readValue(com.huigou.util.JSONUtil.toString(map.get("RDATA")), new TypeReference<List<Map<String, String>>>() {});
            }
//            else {
//                throw new RuntimeException("查询客户、供应商银行失败：" + sapResult.getMESSAGE());
//            }
        } catch (IOException e) {
            throw new RuntimeException("查询客户、供应商银行出错”。");
        }
        return mapList;
    }

    @Override
    public List<Map<String, String>> getCompanyAndBankInfos(String BUKRS) throws IOException {
        Map<String,Object> param = new HashMap<>();
        param.put("BUKRS",BUKRS);
        String execute = null;
        List<Map<String,String>> mapList = new ArrayList<>();
        try {
            execute = httpClient.execute(param, "search/sch_bankaccount");
            Map<String, String> map = JSONObject.parseObject(execute, Map.class);
            SapResult sapResult = JSONObject.parseObject(JSONUtil.toJsonStr(map.get("MSG")), SapResult.class);
            if ("S".equals(sapResult.getTYPE())) {
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                mapList = objectMapper.readValue(com.huigou.util.JSONUtil.toString(map.get("RDATA")), new TypeReference<List<Map<String, String>>>() {});

            }
//            else {
//                throw new RuntimeException("查询公司代码银行账号失败：" + sapResult.getMESSAGE());
//            }
        } catch (IOException e) {
            throw new RuntimeException("查询公司代码银行账号出错”。");
        }
        return mapList;
    }

    @Override
    public List<Map<String, String>> getCompanyOrders(String BUKRS) throws IOException {
        Map<String,Object> param = new HashMap<>();
        param.put("BUKRS",BUKRS);
        param.put("ZTYPE","N");
        String execute = null;
        List<Map<String,String>> mapList = new ArrayList<>();
        try {
            execute = httpClient.execute(param, "search/sch_aufnr");
            Map<String, String> map = JSONObject.parseObject(execute, Map.class);
            SapResult sapResult = JSONObject.parseObject(JSONUtil.toJsonStr(map.get("MSG")), SapResult.class);
            if ("S".equals(sapResult.getTYPE())) {
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                mapList = objectMapper.readValue(com.huigou.util.JSONUtil.toString(map.get("RDATA")), new TypeReference<List<Map<String, String>>>() {});
            }
//            else {
//                throw new RuntimeException("查询公司内部订单失败：" + sapResult.getMESSAGE());
//            }
        } catch (IOException e) {
            throw new RuntimeException("查询公司内部订单出错”。");
        }
        return mapList;
    }

    @Override
    public List<Map<String, String>> getPurchaseOrders(String BUKRS, String PARTNER, String ZEP_FTYPE) {
        Map<String,Object> param = new HashMap<>();
        param.put("BUKRS",BUKRS);
        param.put("PARTNER",PARTNER);
        param.put("ZEP_FTYPE",ZEP_FTYPE);
        String execute = null;
        List<Map<String,String>> mapList = new ArrayList<>();
        try {
            execute = httpClient.execute(param, "search/sch_partner_pur");
            Map<String, String> map = JSONObject.parseObject(execute, Map.class);
            SapResult sapResult = JSONObject.parseObject(JSONUtil.toJsonStr(map.get("MSG")), SapResult.class);
            if ("S".equals(sapResult.getTYPE())) {
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                mapList = objectMapper.readValue(com.huigou.util.JSONUtil.toString(map.get("RDATA")), new TypeReference<List<Map<String, String>>>() {});

            }
//            else {
//                throw new RuntimeException("查询供应商采购订单信息失败：" + sapResult.getMESSAGE());
//            }
        } catch (IOException e) {
            throw new RuntimeException("查询供应商采购订单信息出错”。");
        }
        if (CollectionUtil.isNotEmpty(mapList)) {
            mapList.forEach(map -> {
                map.put("TEXT1", map.get("MENGE"));
            });
        }
        return mapList;
    }

    @Override
    public List<Map<String, String>> getPartnerInvs(String BUKRS,String PARTNER,String ZEP_FTYPE) {
        Map<String,Object> param = new HashMap<>();
        param.put("BUKRS",BUKRS);
        param.put("PARTNER",PARTNER);
        param.put("ZEP_FTYPE",ZEP_FTYPE);
        param.put("ZYL03", DateUtil.getCurrentYear());
        String execute = null;
        List<Map<String,String>> mapList = new ArrayList<>();
        try {
            execute = httpClient.execute(param, "search/sch_partner_inv");
            Map<String, String> map = JSONObject.parseObject(execute, Map.class);
            SapResult sapResult = JSONObject.parseObject(JSONUtil.toJsonStr(map.get("MSG")), SapResult.class);
            if ("S".equals(sapResult.getTYPE())) {
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                mapList = objectMapper.readValue(com.huigou.util.JSONUtil.toString(map.get("RDATA")), new TypeReference<List<Map<String, String>>>() {});

            }
        } catch (IOException e) {
            throw new RuntimeException("查询供应商采购发票号出错”。");
        }
        return mapList;
    }

    @Override
    public List<Map<String, String>> getZcustom(String partner) {
        Map<String,Object> param = new HashMap<>();
        param.put("PARTNER",partner);
        String execute = null;
        List<Map<String,String>> mapList = new ArrayList<>();
        try {
            execute = httpClient.execute(param, "search/SCH_ZCUSTOM");
            Map<String, String> map = JSONObject.parseObject(execute, Map.class);
            SapResult sapResult = JSONObject.parseObject(JSONUtil.toJsonStr(map.get("MSG")), SapResult.class);
            if ("S".equals(sapResult.getTYPE())) {
                ObjectMapper objectMapper = SAPUtils.objectMapper();
                mapList = objectMapper.readValue(com.huigou.util.JSONUtil.toString(map.get("RDATA")), new TypeReference<List<Map<String, String>>>() {});

            }
        } catch (IOException e) {
            throw new RuntimeException("查询报关合同出错”。");
        }
        return mapList;
    }
}
