package com.huigou.topsun.sap.sapApplication.application;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/06/21:08
 * @Description:
 */
public interface SapPaymentApplication {
    /**
     * 根据公司代码和BP标识查询客户、供应商
     * @param BUKRS
     * @param ZEP_BPTYPE
     * @return
     */
    List<Map<String,String>> getCusAndSuppliers(String BUKRS,String ZEP_BPTYPE) throws IOException;

    /**
     * 根据公司代码和BP标识查询客户、供应商银行
     * @param PARTNER
     * @param ZEP_BPTYPE
     * @return
     * @throws IOException
     */
    List<Map<String,String>> getCusAndBanks(String PARTNER,String ZEP_BPTYPE) throws IOException;

    /**
     * 根据公司代码查询银行账号
     * @param BUKRS
     * @return
     * @throws IOException
     */
    List<Map<String,String>> getCompanyAndBankInfos(String BUKRS) throws IOException;

    /**
     * 根据公司代码查询公司内部订单
     * @param BUKRS
     * @return
     * @throws IOException
     */
    List<Map<String,String>> getCompanyOrders(String BUKRS) throws IOException;

    /**
     * 根据公司代码、BP(合作伙伴）、付款申请类别查询订单
     * @param BUKRS
     * @param PARTNER
     * @param ZEP_FTYPE
     * @return
     * @throws IOException
     */
    List<Map<String,String>> getPurchaseOrders(String BUKRS,String PARTNER,String ZEP_FTYPE);

    /**
     * 根据公司代码、BP(合作伙伴）、付款申请类别查询发票
     * @param BUKRS
     * @param PARTNER
     * @param ZEP_FTYPE
     * @return
     */
    List<Map<String, String>> getPartnerInvs(String BUKRS,String PARTNER,String ZEP_FTYPE);

    /**
     * 根据供应商查询报关合同
     * @param partner
     * @return
     */
    List<Map<String, String>> getZcustom(String partner);
}
