package com.huigou.topsun.sap.purchaseInfoRecord.controller;

import com.huigou.topsun.sap.purchaseInfoRecord.application.SapPurchaseInfoRecordItemApplication;
import com.huigou.topsun.sap.purchaseInfoRecord.domain.query.SapPurchaseInfoRecordQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/02/28/15:40
 * @Description:
 */
@Controller
@ControllerMapping("/sapPurchaseInfoRecordItem")
public class SapPurchaseInfoRecordItemController extends CommonController {
    @Resource
    private SapPurchaseInfoRecordItemApplication sapPurchaseInfoRecordItemApplication;

    public String querySapPurchaseInfoRecordItems(){
        SDO sdo = this.getSDO();
        List<String> oldIds = sdo.getStringList("oldIds");
        Map<String, Object> map = new HashMap<>();
        SapPurchaseInfoRecordQueryRequest queryRequest = sdo.toQueryRequest(SapPurchaseInfoRecordQueryRequest.class);
        if (StringUtil.isNotBlank(queryRequest.getSapPurchaseInfoRecordId())){
            map = sapPurchaseInfoRecordItemApplication.querySapPurchaseInfoRecordItem(queryRequest);
        }
        if (StringUtil.isBlank(queryRequest.getSapPurchaseInfoRecordId()) && StringUtil.isNotBlank(queryRequest.getIds())){
            map = sapPurchaseInfoRecordItemApplication.querySapPurchaseInfoRecordItemByIds(queryRequest);
        }
        return toResult(map);
    }

    public String queryUpdateSapPurchaseInfoRecordItems(){
        SDO sdo = this.getSDO();
        Map<String, Object> map = new HashMap<>();
        SapPurchaseInfoRecordQueryRequest queryRequest = sdo.toQueryRequest(SapPurchaseInfoRecordQueryRequest.class);
        if (StringUtil.isNotBlank(queryRequest.getSapPurchaseInfoRecordId())){
            map = sapPurchaseInfoRecordItemApplication.querySapPurchaseInfoRecordItem(queryRequest);
        }
        if (StringUtil.isBlank(queryRequest.getSapPurchaseInfoRecordId()) && StringUtil.isNotBlank(queryRequest.getIds())){
            map = sapPurchaseInfoRecordItemApplication.queryUpdateSapPurchaseInfoRecordItemByIds(queryRequest);
        }
        return toResult(map);
    }

    public String deleteSapPurchaseInfoRecordItem(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        List<String> newIds =new ArrayList<>();
        for (String id:ids){
            if (!id.equals("undefined")){
                newIds.add(id);
            }
        }
       // System.out.println("newIds==="+newIds);
        if (newIds!=null&&newIds.size()>0) {
            sapPurchaseInfoRecordItemApplication.deleteByIds(newIds);
        }
        return success();
    }
}
