package com.huigou.topsun.sap.purchaseInfoRecord.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.common.BillStatus;
import com.huigou.topsun.sap.purchaseInfoRecord.application.SapPurchaseInfoRecordApplication;
import com.huigou.topsun.sap.purchaseInfoRecord.application.SapPurchaseInfoRecordItemApplication;
import com.huigou.topsun.sap.purchaseInfoRecord.domain.SapPurchaseInfoRecord;
import com.huigou.topsun.sap.purchaseInfoRecord.domain.SapPurchaseInfoRecordItem;
import com.huigou.topsun.sap.purchaseInfoRecord.domain.query.SapPurchaseInfoRecordQueryRequest;
import com.huigou.topsun.sap.purchaseInfoRecord.repository.SapPurchaseInfoRecordItemRepository;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.bmp.fn.CodeGenerator;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.JSONUtil;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/02/28/15:40
 * @Description:
 */
@Controller
@ControllerMapping("/sapPurchaseInfoRecord")
public class SapPurchaseInfoRecordController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/purchaseInfoRecord/";
    }

    @Resource
    private SapPurchaseInfoRecordApplication sapPurchaseInfoRecordApplication;
    @Autowired
    private SapPurchaseInfoRecordItemApplication sapPurchaseInfoRecordItemApplication;
    @Autowired
    private SapPurchaseInfoRecordItemRepository sapPurchaseInfoRecordItemRepository;
    @Autowired
    private CodeGenerator codeGenerator;

    public String forwardSapPurchaseInfoRecordList(){
        //this.putAttribute("flag", "0");
        this.putAttribute("statusKindsList", BillStatus.getValidMap());
        return forward("purchaseInfoRecordList");
    }

    public String slicedSapPurchaseInfoRecordList(){
        SDO sdo = this.getSDO();
        SapPurchaseInfoRecordQueryRequest queryRequest = sdo.toQueryRequest(SapPurchaseInfoRecordQueryRequest.class);
        Map<String, Object> map = sapPurchaseInfoRecordApplication.slicedSapPurchaseInfoRecordList(queryRequest);
        return toResult(map);
    }

    public String forwardSapPurchaseInfoRecordDetail(){
        this.putAttribute("processDefinitionKey", SapPurchaseInfoRecordApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        SapPurchaseInfoRecord sapPurchaseInfoRecord = new SapPurchaseInfoRecord();
        sapPurchaseInfoRecord.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        sapPurchaseInfoRecord.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        sapPurchaseInfoRecord.setFlag("new");
        return forward("purchaseInfoRecord",sapPurchaseInfoRecord);
    }

    public String addSapPurchaseInfoRecordDetail() {
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        //String edit=sdo.getString("edit");
        String rowId=sdo.getString("rowId");
        SapPurchaseInfoRecordItem item = JSONUtil.toBean(sdo.getString("param"), SapPurchaseInfoRecordItem.class);
        if (item!=null){
            item.setRowId(rowId);
            if (id.equals(rowId)){
                item.setId("");
            } else {
                item.setId(id);
            }
        }
        this.putAttribute("isReadOnly",sdo.getString("isReadOnly"));
       // SapPurchaseInfoRecord sapPurchaseInfoRecord = sapPurchaseInfoRecordApplication.loadSapPurchaseInfoRecord(id);
        return forward("addPurchaseInfoRecordDetail",item);
    }

    public String updateSapPurchaseInfoRecordDetail() {
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        //String edit=sdo.getString("edit");
        String rowId=sdo.getString("rowId");
        SapPurchaseInfoRecordItem item = JSONUtil.toBean(sdo.getString("param"), SapPurchaseInfoRecordItem.class);
        if (item!=null){
            item.setRowId(rowId);
            if (id.equals(rowId)){
                item.setId("");
            } else {
                item.setId(id);
            }
        }
        this.putAttribute("isReadOnly",sdo.getString("isReadOnly"));
        // SapPurchaseInfoRecord sapPurchaseInfoRecord = sapPurchaseInfoRecordApplication.loadSapPurchaseInfoRecord(id);
        return forward("updatePurchaseInfoRecordDetail",item);
    }

    public String cancelSapPurchaseInfoRecordDetail() {
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        //String edit=sdo.getString("edit");
        String rowId=sdo.getString("rowId");
        SapPurchaseInfoRecordItem item = JSONUtil.toBean(sdo.getString("param"), SapPurchaseInfoRecordItem.class);
        if (item!=null){
            item.setRowId(rowId);
            if (id.equals(rowId)){
                item.setId("");
            } else {
                item.setId(id);
            }
        }
        this.putAttribute("isReadOnly",sdo.getString("isReadOnly"));
        // SapPurchaseInfoRecord sapPurchaseInfoRecord = sapPurchaseInfoRecordApplication.loadSapPurchaseInfoRecord(id);
        return forward("cancelPurchaseInfoRecordDetail",item);
    }

    public String saveSapPurchaseInfoRecordDetail() {
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        //SapPurchaseInfoRecord sapPurchaseInfoRecord = sapPurchaseInfoRecordApplication.loadSapPurchaseInfoRecord(id);
       return forward("addPurchaseInfoRecordDetail",sdo);
       // return success();
    }

    public String showSapPurchaseInfoRecordDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        SapPurchaseInfoRecord sapPurchaseInfoRecord = sapPurchaseInfoRecordApplication.loadSapPurchaseInfoRecord(id);
        this.putAttribute("isReadOnly",sdo.getString("isReadOnly"));
        if (sapPurchaseInfoRecord!=null&&(BizBillStatus.COMPLETED.getId()==sapPurchaseInfoRecord.getStatusId()||
                BizBillStatus.ABORTED.getId()==sapPurchaseInfoRecord.getStatusId())){
            this.putAttribute("isReadOnly","true");
        }
        if ("new".equals(sapPurchaseInfoRecord.getFlag())){
            return forward("purchaseInfoRecord",sapPurchaseInfoRecord);
        }else if ("update".equals(sapPurchaseInfoRecord.getFlag())){
            return forward("updatePurchaseInfoRecord",sapPurchaseInfoRecord);
        }else if ("cancel".equals(sapPurchaseInfoRecord.getFlag())){
            return forward("cancelPurchaseInfoRecord",sapPurchaseInfoRecord);
        }else {
            return forward("purchaseInfoRecord",sapPurchaseInfoRecord);
        }
    }

    public String copyPurchaseRecord(){
        SDO sdo = this.getSDO();
        String ids = sdo.getString("ids");
        this.putAttribute("processDefinitionKey", SapPurchaseInfoRecordApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        this.putAttribute("ids",ids);
        SapPurchaseInfoRecord sapPurchaseInfoRecord = new SapPurchaseInfoRecord();
        sapPurchaseInfoRecord.setId(null);
        sapPurchaseInfoRecord.setStatusId(BizBillStatus.APPLYING.getId());
        Operator operator = getOperator();
        sapPurchaseInfoRecord.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
         String nextCode = codeGenerator.getNextCode("purchaseInfoRecord");
         sapPurchaseInfoRecord.setBillCode(nextCode);
         sapPurchaseInfoRecord.setFlag("new");
        return forward("purchaseInfoRecord",sapPurchaseInfoRecord);
    }

    public String showUpdateSapPurchaseInfoRecordDetail(){
        SDO sdo = this.getSDO();
        String ids = sdo.getString("ids");
        this.putAttribute("processDefinitionKey", SapPurchaseInfoRecordApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        this.putAttribute("ids",ids);
        SapPurchaseInfoRecord sapPurchaseInfoRecord = new SapPurchaseInfoRecord();
        sapPurchaseInfoRecord.setId(null);
        sapPurchaseInfoRecord.setStatusId(BizBillStatus.APPLYING.getId());
        Operator operator = getOperator();
        sapPurchaseInfoRecord.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        String nextCode = codeGenerator.getNextCode("purchaseInfoRecord");
        sapPurchaseInfoRecord.setBillCode(nextCode);
        sapPurchaseInfoRecord.setFlag("update");
        return forward("updatePurchaseInfoRecord",sapPurchaseInfoRecord);
    }

    public String showCancelHandlerInfoRecord(){
        SDO sdo = this.getSDO();
        String ids = sdo.getString("ids");
        this.putAttribute("processDefinitionKey", SapPurchaseInfoRecordApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        this.putAttribute("ids",ids);
        SapPurchaseInfoRecord sapPurchaseInfoRecord = new SapPurchaseInfoRecord();
        sapPurchaseInfoRecord.setId(null);
        sapPurchaseInfoRecord.setStatusId(BizBillStatus.APPLYING.getId());
        Operator operator = getOperator();
        sapPurchaseInfoRecord.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        String nextCode = codeGenerator.getNextCode("purchaseInfoRecord");
        sapPurchaseInfoRecord.setBillCode(nextCode);
        sapPurchaseInfoRecord.setFlag("cancel");
        return forward("cancelPurchaseInfoRecord",sapPurchaseInfoRecord);
    }

    public String cancelPurchaseRecord(){
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        sapPurchaseInfoRecordApplication.cancelPurchaseRecord(id);
        return success();
    }

}
