package com.huigou.topsun.sap.purchaseInfoRecord.application.impl;

import com.huigou.cache.DictUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.purchaseInfoRecord.application.SapPurchaseInfoRecordItemApplication;
import com.huigou.topsun.sap.purchaseInfoRecord.domain.SapPurchaseInfoRecordItem;
import com.huigou.topsun.sap.purchaseInfoRecord.domain.query.SapPurchaseInfoRecordQueryRequest;
import com.huigou.topsun.sap.purchaseInfoRecord.repository.SapPurchaseInfoRecordItemRepository;
import com.huigou.topsun.sap.qualityInfoRecord.application.SapQualityInfoRecordItemApplication;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @Auther: xin.lu
 * @Date: 2024/02/28/15:40
 * @Description:
 */
@Service("sapPurchaseInfoRecordItemApplication")
public class SapPurchaseInfoRecordItemApplicationImpl extends BaseApplication implements SapPurchaseInfoRecordItemApplication {
    @Autowired
    private SapPurchaseInfoRecordItemRepository sapPurchaseInfoRecordItemRepository;
    @Autowired
    private SapQualityInfoRecordItemApplication sapQualityInfoRecordItemApplication;
    @Override
    public void saveSapPurchaseInfoRecordItem(String sapPurchaseInfoRecordId, List<SapPurchaseInfoRecordItem> sapPurchaseInfoRecordItems) {
        sapPurchaseInfoRecordItems.forEach(sapPurchaseInfoRecordItem -> {
//            boolean checked = checkQualityInfo(sapPurchaseInfoRecordItem.getMatnr(), sapPurchaseInfoRecordItem.getLifnr(), sapPurchaseInfoRecordItem.getPrdat());
//            if (!checked){
//                throw  new RuntimeException("供应商：'"+sapPurchaseInfoRecordItem.getLifnr()+"'和物料：'"+sapPurchaseInfoRecordItem.getMatnr()+"'未通过质检或价格有效至已超过合格有效期");
//            }
            sapPurchaseInfoRecordItem.setSapPurchaseInfoRecordId(sapPurchaseInfoRecordId);
            sapPurchaseInfoRecordItem.setCancelFlag("0");
            sapPurchaseInfoRecordItemRepository.save(sapPurchaseInfoRecordItem);
        });
    }

    @Override
    public Map<String, Object> querySapPurchaseInfoRecordItem(SapPurchaseInfoRecordQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getSapPurchaseInfoRecordId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "sapPurchaseInfoRecordItems");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            queryModel.putDictionary("urzla", DictUtil.getDictionary("country"));
            queryModel.putDictionary("mwskz", DictUtil.getDictionary("purchaseMwskz"));
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public Map<String, Object> querySapPurchaseInfoRecordItemByIds(SapPurchaseInfoRecordQueryRequest request) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "sapPurchaseInfoRecordItemByIds");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, request);
        queryModel.putDictionary("mwskz", DictUtil.getDictionary("purchaseMwskz"));
        Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        return map;
    }

    @Override
    public Map<String, Object> queryUpdateSapPurchaseInfoRecordItemByIds(SapPurchaseInfoRecordQueryRequest queryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "queryUpdateSapPurchaseInfoRecordItemByIds");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
        queryModel.putDictionary("mwskz", DictUtil.getDictionary("purchaseMwskz"));
        Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        return map;
    }

    @Override
    public List<SapPurchaseInfoRecordItem> querySapPurchaseInfoRecordItemByMaytkl(SapPurchaseInfoRecordQueryRequest query) {
      QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "querySapPurchaseInfoRecordItemByMaytkl");
      QueryModel model = this.sqlExecutorDao.getQueryModel(queryDescriptor, query);
        model.putDictionary("mwskz", DictUtil.getDictionary("purchaseMwskz"));
        model.setPageIndex(1);
        model.setPageSize(10);
        Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(model);
        List<SapPurchaseInfoRecordItem> list=new ArrayList<>();
        list=(List<SapPurchaseInfoRecordItem>)map.get("Rows");
        return list;

    }
    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            sapPurchaseInfoRecordItemRepository.delete(id);
        });
    }

    @Override
    public List<SapPurchaseInfoRecordItem> findBySapPurchaseInfoRecordId(String sapPurchaseInfoRecordId) {
        return sapPurchaseInfoRecordItemRepository.findBySapPurchaseInfoRecordId(sapPurchaseInfoRecordId);
    }

    @Override
    public void save(SapPurchaseInfoRecordItem sapPurchaseInfoRecordItem) {
        sapPurchaseInfoRecordItemRepository.save(sapPurchaseInfoRecordItem);
    }

    public boolean checkQualityInfo(String matnr, String lifnr, Date datbi){
        return sapQualityInfoRecordItemApplication.checkQualityInfo(matnr,lifnr,datbi);
    }
}
