package com.huigou.topsun.sap.purchaseApproval.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 
 * @TableName sap_purchase_approval_item
 */
@Data
public class SapPurchaseApprovalItemVo {

    /**
     * 项目编号（已删除（EBAN-LOEKZ=X）者不传EP；已结清（EBAN-EBAKZ=X）者也不传（结清指已全部转为采购订单））
     */
    @JsonProperty("BNFPO")
    private String bnfpo;

    /**
     * 项目类别
     */
    @JsonProperty("PSTYP")
    private String pstyp;

    /**
     * 项目类别描述
     */
    @JsonProperty("PTEXT")
    private String ptext;

    /**
     * 科目分配类别
     */
    @JsonProperty("KNTTP")
    private String knttp;

    /**
     * 科目分配类别描述
     */
    @JsonProperty("KNTTX")
    private String knttx;

    /**
     * 物料号 
     */
    @JsonProperty("MATNR")
    private String matnr;

    /**
     * 物料描述
     */
    @JsonProperty("TXZ01")
    private String txz01;

    /**
     * 物料组
     */
    @JsonProperty("MATKL")
    private String matkl;

    /**
     * 物料组描述
     */
    @JsonProperty("WGBEZ")
    private String wgbez;

    /**
     * 采购申请数量
     */
    @JsonProperty("MENGE")
    private BigDecimal menge;

    /**
     * 采购申请计量单位
     */
    @JsonProperty("MEINS")
    private String meins;

    /**
     * 单位描述
     */
    @JsonProperty("MSEHL")
    private String msehl;

    /**
     * 要求交货日期
     */
    @JsonProperty("LFDAT")
    private String lfdat;

    /**
     * 工厂
     */
    @JsonProperty("WERKS")
    private String werks;

    /**
     * 名称
     */
    @JsonProperty("NAME1")
    private String name1;

    /**
     * 库存地点
     */
    @JsonProperty("LGORT")
    private String lgort;

    /**
     * 库存地点的描述 
     */
    @JsonProperty("LGOBE")
    private String lgobe;

    /**
     * 采购组
     */
    @JsonProperty("EKGRP")
    private String ekgrp;

    /**
     * 采购组描述
     */
    @JsonProperty("EKNAM")
    private String eknam;

    /**
     * 评估价格
     */
    @JsonProperty("PREIS")
    private BigDecimal preis;

    /**
     * 价格单位
     */
    @JsonProperty("PEINH")
    private String peinh;

    /**
     * 币种
     */
    @JsonProperty("WAERS")
    private String waers;

    /**
     * 评估金额
     */
    @JsonProperty("RLWRT")
    private BigDecimal rlwrt;

    /**
     * 0需求(请求)日期
     */
    @JsonProperty("BADAT")
    //@JsonFormat(pattern = "yyyy-MM-dd")
    private String badat;

    /**
     * 负责创建对象的人员姓名
     */
    @JsonProperty("ERNAM")
    private String ernam;

    /**
     * 完整的人员名称
     */
    @JsonProperty("NAME_TEXT")
    private String nameText;

    /**
     * 库存转储供货工厂
     */
    @JsonProperty("RESWK")
    private String reswk;

    /**
     * 采购组织
     */
    @JsonProperty("EKORG")
    private String ekorg;

    /**
     * 公司代码
     */
    @JsonProperty("BUKRS")
    private String bukrs;

    /**
     * 删除标识
     */
    @JsonProperty("LOEKZ")
    private String loekz;

}