package com.huigou.topsun.sap.purchaseApproval.domain;

import javax.persistence.*;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

/**
 * SAP采购申请审批表
 * @TableName sap_purchase_approval
 */
@Table(name="sap_purchase_approval")
@Entity
@Data
public class SapPurchaseApproval extends FlowBillAbstractEntity {

    /**
     * 采购申请号
     */
    @Column(name = "BANFN")
    private String banfn;

    /**
     * 采购申请类型（只传输四种：NB、ZNB1、ZNB2和ZSTR）
     */
    @Column(name = "BSART")
    private String bsart;

    /**
     * 采购申请类型描述
     */
    @Column(name = "BATXT")
    private String batxt;

    /**
     * 消息类型
     */
    @Column(name = "TYPE")
    private String type;
    /**
     * 消息内容
     */
    @Column(name = "MESSAGE")
    private String message;

    /**
     * 科目分配类别
     */
    @Column(name = "KNTTP")
    private String knttp;

    /**
     * 采购组
     */
    @Column(name = "EKGRP")
    private String ekgrp;

    /**
     * 撤审原因
     */
    @Column(name = "revoke_reason")
    private String revokeReason;

    /**
     * 撤审类型
     */
    @Column(name = "revoke_type")
    private String revokeType;

    private static final long serialVersionUID = 1L;

    @Override
    protected String getCodeRuleId() {
        return "sapPurchaseApproval";
    }
}