package com.huigou.topsun.sap.purchase.domain;

import javax.persistence.*;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import com.huigou.util.StringUtil;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * SAP采购申请
 * @TableName sap_purchase
 */
@Table(name="sap_purchase")
@Entity
@Data
public class SapPurchase extends FlowBillAbstractEntity {

    /**
     * pr类型
     */
    @Column(name = "BSART")
    private String bsart;

    /**
     * 采购申请编号
     */
    @Column(name = "BANFN")
    private String banfn;

    /**
     *批准日期
     */
    @Column(name = "FRGDT")
    private Date frgdt;

    /**
     * 科目分配类别
     */
    @Column(name = "KNTTP")
    private String knttp;

    /**
     * 撤审原因
     */
    @Column(name = "revoke_reason")
    private String revokeReason;

    /**
     * 撤审类型
     */
    @Column(name = "revoke_type")
    private String revokeType;

    /**
     * 消息类型
     */
    @Column(name = "TYPE")
    private String type;
    /**
     * 消息内容
     */
    @Column(name = "MESSAGE")
    private String message;
    /**
     * 打样单号
     */
    @Column(name = "prototype_code")
    private String prototypeCode;

    /**
     * 成本中心
     */
    @Column(name = "kostl")
    private String kostl;

    public String getKostl() {
        return kostl;
    }

    public void setKostl(String kostl) {
        if (StringUtil.isBlank(kostl)) {
            return;
        }
        this.kostl = kostl;
    }

    private static final long serialVersionUID = 1L;

    @Override
    protected String getCodeRuleId() {
        return "sapPurchase";
    }
}