package com.huigou.topsun.sap.productScrapApply.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/07/09/14:47
 * @Description: 物品报废申请与过账平台
 */
@Data
@Table(name = "sap_product_scrap_apply_item")
@Entity
public class ProductScrapApplyItem extends AbstractEntity {

    @Column(name = "product_scrap_apply_id")
    private String productScrapApplyId;

    /**
     * 报废申请号
     */
    @Column(name = "ZSANUM")
    private String zsanum;
    /**
     * 项目
     */
    @Column(name = "ZSAPOS")
    private String zsapos;

    /**
     * 物料
     */
    @Column(name = "MATNR")
    private String matnr;

    /**
     * 物料描述
     */
    @JsonProperty("MAKTX")
    private String maktx;

    /**
     * 数量
     */
    @Column(name = "ERFMG")
    private String erfmg;

    /**
     * 单位
     */
    @Column(name = "ERFME")
    private String erfme;

    /**
     * 工厂
     */
    @Column(name = "WERKS")
    private String werks;

    /**
     * 存储地点
     */
    @Column(name = "LGORT")
    private String lgort;

    /**
     * 成本中心
     */
    @Column(name = "KOSTL")
    private String kostl;

    /**
     * 批次
     */
    @Column(name = "CHARG")
    private String charg;

    /**
     * 序列号/PL号
     */
    @Column(name = "SERNR")
    private String sernr;

    /**
     * 文本
     */
    @Column(name = "ZTXT")
    private String ztxt;

    /**
     * 申请日期
     */
    @Column(name = "ZDAT")
    private Date zdat;

    /**
     * 申请人
     */
    @Column(name = "ZUSER1")
    private String zuser1;

    /**
     * 工厂
     */
    @Column(name = "WERKS_NAME")
    private String werksName;

    /**
     * 存储地点
     */
    @Column(name = "LGORT_NAME")
    private String lgortName;

    /**
     * 成本中心
     */
    @Column(name = "KOSTL_NAME")
    private String kostlName;

    /**
     * 单位
     */
//    @Column(name = "ERFME_NAME")
//    private String erfmeName;

}
