package com.huigou.topsun.sap.produceMaterialApply.application.impl;

import com.huigou.data.domain.model.CommonDomainConstants;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.produceMaterialApply.application.ProduceMaterialApplyApplication;
import com.huigou.topsun.sap.produceMaterialApply.domain.query.ProduceMaterialApplyQueryRequest;
import com.huigou.topsun.sap.produceMaterialApply.repository.ProduceMaterialApplyRepository;
import com.huigou.topsun.sap.produceMaterialApply.domain.ProduceMaterialApply;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.bpm.FlowBroker;
import com.huigou.util.ClassHelper;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.DelegateTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/05/31/15:07
 * @Description:
 */
@Service("produceMaterialApplyApplication")
public class ProduceMaterialApplyApplicationImpl extends FlowBroker implements ProduceMaterialApplyApplication {
    @Autowired
    private ProduceMaterialApplyRepository produceMaterialApplyRepository;
    @Override
    protected String saveBizAndApprovalData() {
        super.saveBizAndApprovalData();
        ProduceMaterialApply produceMaterialApply = getBizEntity(ProduceMaterialApply.class);
        if (produceMaterialApply.isNew()) {
            produceMaterialApply.setStatusId(BizBillStatus.APPLYING.getId());
        } else {
            produceMaterialApply = (ProduceMaterialApply) commonDomainService.loadAndFillinProperties(produceMaterialApply);
        }
        produceMaterialApply = produceMaterialApplyRepository.save(produceMaterialApply);
        return produceMaterialApply.getId();
    }

    @Override
    protected Map<String, Object> getProcessBizParams(String bizId) {
        // 返回业务数据给流程实例，
        return ClassHelper.toMap(produceMaterialApplyRepository.getOne(bizId));
    }

    /**
     * 任务完成前执行
     */
    @Override
    protected void onBeforeComplete(DelegateTask delegateTask) {
        super.onBeforeComplete(delegateTask);
        String bizId = delegateTask.getExecution().getProcessBusinessKey();
        updateStatus(bizId, BizBillStatus.APPROVING);
    }

    @Transactional
    protected void updateStatus(String bizId, BizBillStatus status) {
        Assert.hasText(bizId, CommonDomainConstants.ID_NOT_BLANK);
        this.commonDomainService.updateStatus(ProduceMaterialApply.class, bizId, status.getId());
    }

    /**
     * 流程撤销事件
     **/
    @Override
    protected void onRecallProcessInstance(DelegateExecution delegateExecution) {
        String bizId = delegateExecution.getProcessBusinessKey();
        // 修改单据状态为申请
        updateStatus(bizId, BizBillStatus.APPLYING);
    }

    /**
     * 回收事件
     **/
    @Override
    protected void onWithdraw(DelegateTask delegateTask, String destActivityId) {
        super.onWithdraw(delegateTask, destActivityId);
        String bizId = delegateTask.getExecution().getProcessBusinessKey();
        if (destActivityId.equalsIgnoreCase("apply")) {
            updateStatus(bizId, BizBillStatus.APPLYING);
        }
    }

    @Override
    protected void onEnd(DelegateExecution delegateExecution) {
        //super.onEnd(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        BizBillStatus status = approvePassed() ? BizBillStatus.COMPLETED : BizBillStatus.ABORTED;
        ProduceMaterialApply produceMaterialApply = produceMaterialApplyRepository.findOne(bizId);
        produceMaterialApply.setStatusId(status.getId());
        produceMaterialApplyRepository.save(produceMaterialApply);
    }

    @Override
    protected void onAbortProcessInstance(DelegateExecution delegateExecution) {
        super.onAbortProcessInstance(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        ProduceMaterialApply produceMaterialApply = produceMaterialApplyRepository.findOne(bizId);
        produceMaterialApply.setStatusId(BizBillStatus.ABORTED.getId());
        produceMaterialApplyRepository.save(produceMaterialApply);
    }

    /**
     * @param delegateTask
     * @param destActivityId 回退到的目标节点id
     */
    @Override
    protected void onBack(DelegateTask delegateTask, String destActivityId) {
        super.onBack(delegateTask, destActivityId);
        if ("Apply".equalsIgnoreCase(destActivityId)) {
            String bizId = delegateTask.getExecution().getProcessBusinessKey();
            ProduceMaterialApply produceMaterialApply = produceMaterialApplyRepository.findOne(bizId);
            produceMaterialApply.setStatusId(BizBillStatus.APPLYING.getId());
            produceMaterialApplyRepository.save(produceMaterialApply);
        }
    }
    
    @Override
    public Map<String, Object> slicedProduceMaterialApplyList(ProduceMaterialApplyQueryRequest queryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "produceMaterialApply");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
        Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            produceMaterialApplyRepository.delete(id);
        });
    }

    @Override
    public ProduceMaterialApply findProduceMaterialApplyById(String id) {
        return produceMaterialApplyRepository.findOne(id);
    }
}
