package com.huigou.topsun.sap.processQuotedPrice.domain.query;

import com.huigou.data.domain.query.QueryAbstractRequest;
import lombok.Data;

import java.util.Calendar;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/10/30/14:10
 * @Description:
 */
@Data
public class ProcessQuotedPriceQueryRequest extends QueryAbstractRequest {

    private String billCode;

    private String processQuotedPriceId;

    private String processQuotedPriceItemId;

    private String deptName;
    private String deptId;
    private String personMemberName;
    private String personMemberId;
    private String productCode;
    private String productName;
    private Date fillinDateBegin;
    private Date fillinDateEnd;
    private String statusKind;

    public void setFillinDateEnd(Date fillinDateEnd) {
        if (fillinDateEnd != null) {
            // 使用Calendar类给日期加一天
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(fillinDateEnd);
            calendar.add(Calendar.DATE, 1); // 给日期加上一天
            // 获取新的Date对象
            fillinDateEnd = calendar.getTime();
        }
        this.fillinDateEnd = fillinDateEnd;
    }
}
