package com.huigou.topsun.sap.processQuotedPrice.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.processQuotedPrice.application.ProcessQuotedPriceItemNumberApplication;
import com.huigou.topsun.sap.processQuotedPrice.domain.ProcessQuotedPriceItemNumber;
import com.huigou.topsun.sap.processQuotedPrice.domain.query.ProcessQuotedPriceQueryRequest;
import com.huigou.topsun.sap.processQuotedPrice.repository.ProcessQuotedPriceItemNumberRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/10/30/14:18
 * @Description:
 */
@Service("processQuotedPriceItemNumberApplication")
public class ProcessQuotedPriceItemNumberApplicationImpl extends BaseApplication implements ProcessQuotedPriceItemNumberApplication {
    @Autowired
    private ProcessQuotedPriceItemNumberRepository processQuotedPriceItemNumberRepository;
    @Override
    public void saveProcessQuotedPriceItemNumbers(String processQuotedPriceItemId, List<ProcessQuotedPriceItemNumber> processQuotedPriceOrderItemNumbers) {
        for (ProcessQuotedPriceItemNumber processQuotedPriceOrderItemNumber : processQuotedPriceOrderItemNumbers) {
            processQuotedPriceOrderItemNumber.setProcessQuotedPriceItemId(processQuotedPriceItemId);
            if (processQuotedPriceOrderItemNumber.getNumberFrom() == null){
                processQuotedPriceOrderItemNumber.setNumberFrom(BigDecimal.ZERO);
            }
            if (processQuotedPriceOrderItemNumber.getNumberTo() == null){
                processQuotedPriceOrderItemNumber.setNumberTo(new BigDecimal(999999999));
            }
            //拼接数量区间：100<数量<=200
            processQuotedPriceOrderItemNumber
                    .setNumberSection(
                            processQuotedPriceOrderItemNumber.getNumberFrom()+
                                    "<数量"+ "<=" +
                                    processQuotedPriceOrderItemNumber.getNumberTo());
            processQuotedPriceItemNumberRepository.save(processQuotedPriceOrderItemNumber);
        }
    }

    @Override
    public Map<String, Object> queryProcessQuotedPriceItemNumbers(ProcessQuotedPriceQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getProcessQuotedPriceItemId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "processQuotedPriceItemNumbers");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            processQuotedPriceItemNumberRepository.delete(id);
        });
    }

    @Override
    public List<ProcessQuotedPriceItemNumber> findByProcessQuotedPriceItemId(String processQuotedPriceItemId) {
        return processQuotedPriceItemNumberRepository.findByProcessQuotedPriceItemId(processQuotedPriceItemId);
    }
}
