package com.huigou.topsun.sap.processOutsource.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.common.BillStatus;
import com.huigou.topsun.sap.processOutsource.application.ProcessOutsourceApplication;
import com.huigou.topsun.sap.processOutsource.application.ProcessOutsourceMaterialApplication;
import com.huigou.topsun.sap.processOutsource.application.ProcessOutsourceOrderItemApplication;
import com.huigou.topsun.sap.processOutsource.domain.ProcessOutsource;
import com.huigou.topsun.sap.processOutsource.domain.query.ProcessOutsourceQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/08/02/10:43
 * @Description:
 */
@Controller
@ControllerMapping("/processOutsource")
public class ProcessOutsourceController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/processOutsource/";
    }

    @Autowired
    private ProcessOutsourceApplication processOutsourceApplication;
    @Autowired
    private ProcessOutsourceMaterialApplication processOutsourceMaterialApplication;
    @Autowired
    private ProcessOutsourceOrderItemApplication processOutsourceOrderItemApplication;

    public String forwardProcessOutsourceList(){
        this.putAttribute("statusKindsList", BillStatus.getValidMap());
        return forward("processOutsourceList");
    }

    public String slicedProcessOutsourceList(){
        SDO sdo = this.getSDO();
        ProcessOutsourceQueryRequest queryRequest = sdo.toQueryRequest(ProcessOutsourceQueryRequest.class);
        Map<String, Object> map = processOutsourceApplication.slicedProcessOutsourceList(queryRequest);
        return toResult(map);
    }

    public String forwardProcessOutsourceDetail(){
        this.putAttribute("processDefinitionKey", ProcessOutsourceApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        ProcessOutsource processOutsource = new ProcessOutsource();
        processOutsource.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        processOutsource.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("processOutsourceDetail",processOutsource);
    }

    public String showProcessOutsourceDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        ProcessOutsource processOutsource = processOutsourceApplication.loadProcessOutsource(id);
        return forward("processOutsourceDetail",processOutsource);
    }

    public String queryProcessOutsourceOrderItems(){
        SDO sdo = this.getSDO();
        ProcessOutsourceQueryRequest queryRequest = sdo.toQueryRequest(ProcessOutsourceQueryRequest.class);
        Map<String, Object> map = this.processOutsourceOrderItemApplication.queryProcessOutsourceOrderItems(queryRequest);
        return toResult(map);
    }

    public String deleteProcessOutsourceOrderItem(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        processOutsourceOrderItemApplication.deleteByIds(ids);
        return success();
    }

    public String queryProcessOutsourceMaterials(){
        SDO sdo = this.getSDO();
        ProcessOutsourceQueryRequest queryRequest = sdo.toQueryRequest(ProcessOutsourceQueryRequest.class);
        Map<String, Object> map = this.processOutsourceMaterialApplication.queryProcessOutsourceMaterials(queryRequest);
        return toResult(map);
    }

    public String deleteProcessOutsourceMaterial(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        processOutsourceOrderItemApplication.deleteByIds(ids);
        return success();
    }

    /**
     * 跳转到选择编排单-工单页面
     * @return
     */
    public String showAddAufnrDetail(){
        return forward("showAddAufnrDetail");
    }

    /**
     * 根据编排单查询工单
     * @return
     */
    public String queryAufnrFromMes(){
        SDO sdo = this.getSDO();
        ProcessOutsourceQueryRequest queryRequest = sdo.toQueryRequest(ProcessOutsourceQueryRequest.class);
        List<Map<String,String>> mapList = processOutsourceApplication.queryAufnrFromMes(queryRequest.getArrangeNo());
        return packGridDataAndResult(mapList);
    }


}
