package com.huigou.topsun.sap.priceMasterData.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @TableName sap_price_master_data
 */
@Table(name = "sap_price_master_data")
@Data
@Entity
public class SapPriceMasterData extends FlowBillAbstractEntity {

//    @OneToMany
//    private SapPriceMasterDataItem sapPriceMasterDataItem;

    /**
     * KSCHL-条件类型(可选)
     * 通过选择相应的条件类型维护不同的价格
     * PR01-工厂价格；
     * ZPR1-品牌价格
     */
    @Column(name = "KSCHL")
    private String kschl;

    /**
     * VKORG-销售组织(可选)
     * 目前只能选择1000-广州科技销售组织，其它销售组织隐藏
     * 1000-广州科技销售组织；
     * 2000-广州金库销售组织；
     */
    @Column(name = "VKORG")
    private String vkorg;

    /**
     * VTWEG-分销渠道(可选)
     * 10-内销；
     * 20-外销；
     * 80-集团内
     */
    @Column(name = "VTWEG")
    private String vtweg;

    /**
     * KUNNR-客户(可选)
     * 通过调用客户主数据查询接口，搜索到相应的客户编号与描述
     */
    @Column(name = "KUNNR")
    private String kunnr;

    /**
     * 联系方式
     */
    @Column(name = "tele_phone")
    private String telePhone;

    private static final long serialVersionUID = 1L;

    @Override
    protected String getCodeRuleId() {
        return "sapPriceMasterData";
    }
}