package com.huigou.topsun.sap.permit.controller;

import com.huigou.topsun.sap.permit.application.SapPermitItemApplication;
import com.huigou.topsun.sap.permit.domain.query.SapPermitQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;
import java.util.Map;

/**
 * @Auther: LXH
 * @Date:  2024/03/26 10:10
 * @Description:
 */
@Controller
@ControllerMapping("/sapPermitItem")
public class SapPermitItemController extends CommonController {
    @Autowired
    private SapPermitItemApplication sapPermitItemApplication;

    public String querySapPermitItems(){
        SDO sdo = this.getSDO();
        SapPermitQueryRequest queryRequest = sdo.toQueryRequest(SapPermitQueryRequest.class);
        Map<String, Object> map = sapPermitItemApplication.querySapPermitItems(queryRequest);
        return toResult(map);
    }

    public String deleteSapPermitItems(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        sapPermitItemApplication.deleteByIds(ids);
        return success();
    }
}
