package com.huigou.topsun.sap.nonProdApply.domain.query;

import com.huigou.data.domain.query.FlowBillSuperQueryRequest;
import lombok.Data;

import java.util.Calendar;
import java.util.Date;

public class NonProdApplyBaseInfoQueryRequest extends FlowBillSuperQueryRequest {

    /**
     * 维护类型
     */
    private String maintenanceType;
    /**
     * 维护类型详细
     */
    private String maintainTypeDetail;

    private Integer distribute;

    /**
     * 批准状态
     */
    private String approvalStatus;

    /**
     * 批准人
     */
    private String approver;

    /**
     * 批准日期
     */
    private Date approvalDate;

    /**
     * 通用品名
     */
    private String genericName;

    /**
     * 适用标准
     */
    private String applicableStandard;

    /**
     * 基本计量单位
     */
    private String baseUnit;

    /**
     * 规格
     */
    private String specifications;

    /**
     * 材质
     */
    private String material;

    /**
     * 版式
     */
    private String design;

    /**
     * 尺码
     */
    private String size;

    /**
     * 品牌
     */
    private String brand;

    /**
     * 用途
     */
    private String materialUsage;

    /**
     * 物品属性
     */

    private String itemAttributes;

    /**
     * 业务用途
     */

    private String businessUsage;

    /**
     * 文本说明
     */
    private String textDescription;

    //物料编码
    private String matnr;

    //汉语品名
    private String  maktx;

    private String  billCode;

    private Date  startDate;

    private Date  endDate;

    private String  werks;

    public String getMaintenanceType() {
        return maintenanceType;
    }

    public void setMaintenanceType(String maintenanceType) {
        this.maintenanceType = maintenanceType;
    }

    public String getApprovalStatus() {
        return approvalStatus;
    }

    public void setApprovalStatus(String approvalStatus) {
        this.approvalStatus = approvalStatus;
    }

    public String getApprover() {
        return approver;
    }

    public void setApprover(String approver) {
        this.approver = approver;
    }

    public Date getApprovalDate() {
        return approvalDate;
    }

    public void setApprovalDate(Date approvalDate) {
        this.approvalDate = approvalDate;
    }

    public String getGenericName() {
        return genericName;
    }

    public void setGenericName(String genericName) {
        this.genericName = genericName;
    }

    public String getApplicableStandard() {
        return applicableStandard;
    }

    public void setApplicableStandard(String applicableStandard) {
        this.applicableStandard = applicableStandard;
    }

    public String getBaseUnit() {
        return baseUnit;
    }

    public void setBaseUnit(String baseUnit) {
        this.baseUnit = baseUnit;
    }

    public String getSpecifications() {
        return specifications;
    }

    public void setSpecifications(String specifications) {
        this.specifications = specifications;
    }

    public String getMaterial() {
        return material;
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    public String getDesign() {
        return design;
    }

    public void setDesign(String design) {
        this.design = design;
    }

    public String getSize() {
        return size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getMaterialUsage() {
        return materialUsage;
    }

    public void setMaterialUsage(String materialUsage) {
        this.materialUsage = materialUsage;
    }

    public String getItemAttributes() {
        return itemAttributes;
    }

    public void setItemAttributes(String itemAttributes) {
        this.itemAttributes = itemAttributes;
    }

    public String getBusinessUsage() {
        return businessUsage;
    }

    public void setBusinessUsage(String businessUsage) {
        this.businessUsage = businessUsage;
    }

    public String getTextDescription() {
        return textDescription;
    }

    public void setTextDescription(String textDescription) {
        this.textDescription = textDescription;
    }

    public String getMatnr() {
        return matnr;
    }

    public void setMatnr(String matnr) {
        this.matnr = matnr;
    }

    public String getMaktx() {
        return maktx;
    }

    public void setMaktx(String maktx) {
        this.maktx = maktx;
    }

    @Override
    public String getBillCode() {
        return billCode;
    }

    @Override
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        if (endDate != null) {
            // 使用Calendar类给日期加一天
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(endDate);
            calendar.add(Calendar.DATE, 1); // 给日期加上一天
            // 获取新的Date对象
            endDate = calendar.getTime();
        }
        this.endDate = endDate;
    }

    public String getWerks() {
        return werks;
    }

    public void setWerks(String werks) {
        this.werks = werks;
    }

    public String getMaintainTypeDetail() {
        return maintainTypeDetail;
    }

    public void setMaintainTypeDetail(String maintainTypeDetail) {
        this.maintainTypeDetail = maintainTypeDetail;
    }

    public Integer getDistribute() {
        return distribute;
    }

    public void setDistribute(Integer distribute) {
        this.distribute = distribute;
    }
}