package com.huigou.topsun.sap.nonProdApply.domain;

import com.huigou.topsun.common.AbstractPortalOrg;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 
 * @TableName tmp_non_prod_material_data
 * 物料导入模板临时数据表
 */
@Table(name="tmp_non_prod_material_data")
@Data
@Entity
public class TmpNonProdMaterialDataImport extends AbstractPortalOrg {
    /**
     * 物料编码
     */
    @Column(name = "MATNR")
    private String matnr;

    /**
     * 行业
     */
    @Column(name = "MBRSH")
    private String mbrsh;

    /**
     * 物料类型
     */
    @Column(name = "MTART")
    private String mtart;

    /**
     * 工厂
     */
    @Column(name = "WERKS")
    private String werks;

    @Column(name = "WERKS_NAME")
    private String werksName;

    /**
     * 库存地点
     */
    @Column(name = "LGORT")
    private String lgort;

    @Column(name = "LGORT_NAME")
    private String lgortName;

    /**
     * 库存地点（存储）
     */
    @Column(name = "LGORT_QM")
    private String lgortQm;

    @Column(name = "LGORT_QM_NAME")
    private String lgortQmName;

    /**
     * 销售组织
     */
    @Column(name = "VKORG")
    private String vkorg;

    @Column(name = "VKORG_NAME")
    private String vkorgName;

    /**
     * 分销渠道
     */
    @Column(name = "VTWEG")
    private String vtweg;

    @Column(name = "VTWEG_NAME")
    private String vtwegName;

    /**
     * 仓库号
     */
    @Column(name = "LGNUM")
    private String lgnum;

    @Column(name = "LGNUM_NAME")
    private String lgnumName;

    /**
     * 存储类型
     */
    @Column(name = "LGTYP")
    private String lgtyp;

    @Column(name = "LGTYP_NAME")
    private String lgtypName;

    /**
     * 汉语品名
     */
    @Column(name = "MAKTX")
    private String maktx;

    /**
     * 汉语语言
     */
    @Column(name = "SPARS")
    private String spars;

    /**
     * 英语品名
     */
    @Column(name = "MAKTX_EN")
    private String maktxEn;
    /**
     * 英语语言码
     */
    @Column(name = "SPARS_EN")
    private String sparsEn;
    /**
     * 基本计量单位
     */
    @Column(name = "MEINS")
    private String meins;

    @Column(name = "MEINS_NAME")
    private String meinsName;

    /**
     * 物料组
     */
    @Column(name = "MATKL")
    private String matkl;

    @Column(name = "MATKL_NAME")
    private String matklName;

    /**
     * 毛重
     */
    @Column(name = "BRGEW")
    private String brgew;

    /**
     * 净重
     */
    @Column(name = "NTGEW")
    private String ntgew;

    /**
     * 重量单位
     */
    @Column(name = "GEWEI")
    private String gewei;
    /**
     * 产品组
     */
    @Column(name = "SPART")
    private String spart;
    @Column(name = "SPART_NAME")
    private String spartName;

    /**
     * 基本数据文本语言
     */
    @Column(name = "SPTXT")
    private String sptxt;

    /**
     * 文本说明中文
     */
    @Column(name = "MAKTX_DESC_CN")
    private String maktxDescCn;

    /**
     * 文本说明英文
     */
    @Column(name = "MAKTX_DESC_EN")
    private String maktxDescEn;

    /**
     * 销售计量单位
     */
    @Column(name = "VRKME")
    private String vrkme;
    @Column(name = "vrkme_name")
    private String vrkmeName;

    /**
     * 销售计量单位转换分母
     */
    @Column(name = "UMREN_SALE")
    private String umrenSale;

    /**
     * 销售计量单位转换分子
     */
    @Column(name = "UMREZ_SALE")
    private String umrezSale;

    /**
     * 采购计量单位
     */
    @Column(name = "BSTME")
    private String bstme;

    @Column(name = "BSTME_NAME")
    private String bstmeName;

    /**
     * 转换分母（采购）
     */
    @Column(name = "UMREN_PURCH")
    private String umrenPurch;

    /**
     * 转换分子（采购）
     */
    @Column(name = "UMREZ_PURCH")
    private String umrezPurch;


    /**
     * 转换分母
     */
    @Column(name = "UMREN")
    private String umren;

    /**
     * 转换分子
     */
    @Column(name = "UMREZ")
    private String umrez;

    /**
     * 类型
     */
    @Column(name = "KLART")
    private String klart;

    /**
     * 类类型
     */
    @Column(name = "CLASS")
    private String classify;

    /**
     * 税分类
     */
    @Column(name = "TAXKM")
    private String taxkm;

    /**
     * 批次管理
     */
    @Column(name = "XCHPF")
    private String xchpf;

    /**
     * 统计组
     */
    @Column(name = "VERSG")
    private String versg;

    /**
     * 产品层级
     */
    @Column(name = "PRODH")
    private String prodh;

    /**
     * 会计科目组
     */
    @Column(name = "KTGRM")
    private String ktgrm;

    /**
     * 品牌
     */
    @Column(name = "MVGR1")
    private String mvgr1;

    /**
     * 经营类型
     */
    @Column(name = "MVGR2")
    private String mvgr2;

    /**
     * 可用性检查组
     */
    @Column(name = "MTVFP")
    private String mtvfp;

    /**
     * 运输组
     */
    @Column(name = "TRAGR")
    private String tragr;

    /**
     * 装载组
     */
    @Column(name = "LADGR")
    private String ladgr;
    @Column(name = "LADGR_NAME")
    private String ladgrName;

    /**
     * 利润中心
     */
    @Column(name = "PRCTR")
    private String prctr;

    /**
     * 默认采购组
     */
    @Column(name = "EKGRP")
    private String ekgrp;

    @Column(name = "EKGRP_NAME")
    private String ekgrpName;

    /**
     * 过账到质检
     */
    @Column(name = "INSMK")
    private String insmk;

    /**
     * 收货处理天数
     */
    @Column(name = "WEBAZ")
    private String webaz;

    /**
     * MRP类型
     */
    @Column(name = "DISMM")
    private String dismm;

    /**
     * 重订货点
     */
    @Column(name = "MINBE")
    private String minbe;
    /**
     * MRP控制者
     */
    @Column(name = "DISPO")
    private String dispo;

    /**
     * 最大批量
     */
    @Column(name = "BSTMA")
    private String bstma;

    /**
     * 最小批量
     */
    @Column(name = "BSTMI")
    private String bstmi;

    /**
     * 固定批量
     */
    @Column(name = "BSTFE")
    private String bstfe;

    /**
     * 舍入值
     */
    @Column(name = "BSTRF")
    private String bstrf;

    /**
     * 最大存货水平
     */
    @Column(name = "MABST")
    private String mabst;
    /**
     * 倒冲标志
     */
    @Column(name = "RGEKZ")
    private String rgekz;

    /**
     * 生产发料默认存储地
     */
    @Column(name = "LGPRO")
    private String lgpro;
    @Column(name = "LGPRO_NAME")
    private String lgproName;

    /**
     * 采购收货默认存储地
     */
    @Column(name = "LGFSB")
    private String lgfsb;

    @Column(name = "LGFSB_NAME")
    private String lgfsbName;

    /**
     * 自制天数
     */
    @Column(name = "DZEIT")
    private String dzeit;
    /**
     * 计划交货天数
     */
    @Column(name = "PLIFZ")
    private String plifz;
    /**
     * 安全库存
     */
    @Column(name = "EISBE")
    private String eisbe;

    /**
     *期间标识
     */
    @Column(name = "PERKZ")
    private String perkz;
    /**
     * 计划策略组
     */
    @Column(name = "STRGR")
    private String strgr;

    /**
     * 消耗模式
     */
    @Column(name = "VRMOD")
    private String vrmod;

    /**
     * 逆推消耗期间
     */
    @Column(name = "VINT1")
    private String vint1;

    /**
     * 顺推消耗期间
     */
    @Column(name = "VINT2")
    private String vint2;

    /**
     * 独立/集中
     */
    @Column(name = "SBDKZ")
    private String sbdkz;

    /**
     * 投料计量单位
     * 发货计量单位
     */
    @Column(name = "AUSME")
    private String ausme;
    @Column(name = "AUSME_NAME")
    private String ausmeName;

    /**
     * 转换分母（生产）
     */
    @Column(name = "UMREN_PROD")
    private String umrenProd;

    /**
     * 转换分子（生产）
     */
    @Column(name = "UMREZ_PROD")
    private String umrezProd;

    /**
     * 生产主管
     */
    @Column(name = "FEVOR")
    private String fevor;

    /**
     * 生产计划参数文件
     */
    @Column(name = "SFCPF")
    private String sfcpf;

    /**
     * 存储条件
     */
    @Column(name = "RAUBE")
    private String raube;

    @Column(name = "RAUBE_NAME")
    private String raubeName;

    /**
     * 最小货架寿命
     */
    @Column(name = "MHDRZ")
    private String mhdrz;

    /**
     * 总有效期
     */
    @Column(name = "MHDHB")
    private String mhdhb;

    /**
     * 有效期标识
     */
    @Column(name = "IPRKZ")
    private String iprkz;

    /**
     * 过期日期
     */
    @Column(name = "SLED_BBD")
    private String sledBbd;

    /**
     * 序列号参数文件
     */
    @Column(name = "SERNP")
    private String sernp;

    /**
     * 序列号层次
     */
    @Column(name = "SERLV")
    private String serlv;

    /**
     * 存货下架存储类型
     */
    @Column(name = "LTKZA")
    private String ltkza;

    @Column(name = "LTKZA_NAME")
    private String ltkzaName;

    /**
     * 存货上架存储类型
     */
    @Column(name = "LTKZE")
    private String ltkze;

    @Column(name = "LTKZE_NAME")
    private String ltkzeName;

    /**
     * 存储分区标识
     */
    @Column(name = "LGBKZ")
    private String lgbkz;

    @Column(name = "LGBKZ_NAME")
    private String lgbkzName;

    /**
     * 仓库设施1存储数量
     * 仓位最大承载
     */
    @Column(name = "LHMG1")
    private String lhmg1;

    /**
     * 仓库设施1存储单位
     * 承载单位
     */
    @Column(name = "LHME1")
    private String lhme1;

    @Column(name = "LHME1_NAME")
    private String lhme1Name;
    /**
     * 仓库设施1类型
     * 仓储单位类型
     */
    @Column(name = "LETY1")
    private String lety1;

    /**
     * 评估分类
     */
    @Column(name = "BKLAS")
    private String bklas;

    /**
     * 销售评估类
     */
    @Column(name = "EKLAS")
    private String eklas;

    /**
     * 价格确定
     */
    @Column(name = "MLAST")
    private String mlast;

    /**
     * 定价基数
     */
    @Column(name = "PEINH")
    private String peinh;

    /**
     * 价格控制
     */
    @Column(name = "VPRSV")
    private String vprsv;

    /**
     * 数量结构
     */
    @Column(name = "EKALR")
    private String ekalr;
    /**
     * 物料来源
     */
    @Column(name = "HKMAT")
    private String hkmat;

    /**
     * 差异码
     */
    @Column(name = "AWSLS")
    private String awsls;






    /**
     * 集团删除
     */
    @Column(name = "LVORM")
    private String lvorm;

    /**
     * 销售项目类别组
     */
    @Column(name = "MTPOS_MARA")
    private String mtposMara;

    /**
     * 适用标准
     */
    @Column(name = "NORMT")
    private String normt;

    /**
     * 包装物料组
     */
    @Column(name = "MAGRV")
    private String magrv;

    /**
     * 体积
     */
    @Column(name = "VOLUM")
    private String volum;

    /**
     * 体积单位
     */
    @Column(name = "VOLEH")
    private String voleh;

    /**
     * 交货工厂
     */
    @Column(name = "DWERK")
    private String dwerk;

    @Column(name = "DWERK_NAME")
    private String dwerkName;
    /**
     * 税收发运国
     */
    @Column(name = "ALAND")
    private String aland;

    @Column(name = "ALAND_NAME")
    private String alandName;

    /**
     * 物料定价组
     */
    @Column(name = "KONDM")
    private String kondm;

    /**
     * 用途
     */
    @Column(name = "MVGR3")
    private String mvgr3;

    /**
     * 备用
     */
    @Column(name = "MVGR4")
    private String mvgr4;

    /**
     * 备用
     */
    @Column(name = "MVGR5")
    private String mvgr5;

    /**
     * 销售项次组
     */
    @Column(name = "MTPOS")
    private String mtpos;


    /**
     * MPN参数
     */
    @Column(name = "MPROF")
    private String mprof;

    /**
     * 工厂（采购）
     */
    @Column(name = "WERKS_PURCH")
    private String werksPurch;

    /**
     * MRP组
     */
    @Column(name = "DISGR")
    private String disgr;


    /**
     * 批量规模
     */
    @Column(name = "DISLS")
    private String disls;

    /**
     * 采购类型
     */
    @Column(name = "BESKZ")
    private String beskz;

    /**
     * 特殊采购
     */
    @Column(name = "SOBSL")
    private String sobsl;

    /**
     * 排程边际码
     */
    @Column(name = "FHORI")
    private String fhori;

    /**
     * 最小安全库存
     */
    @Column(name = "EISLO")
    private String eislo;

    /**
     * 补货提前天数
     */
    @Column(name = "WZEIT")
    private String wzeit;

    /**
     * BOM选择方法
     */
    @Column(name = "ALTSL")
    private String altsl;

    /**
     * 库存地MRP标识
     */
    @Column(name = "DISKZ")
    private String diskz;



    /**
     * 工厂（质检）
     */
    @Column(name = "WERKS_QM")
    private String werksQm;

    /**
     * 工厂（利润中心）
     */
    @Column(name = "WERKS_PROFIT")
    private String werksProfit;

    /**
     * 库存地点（仓库）
     */
    @Column(name = "LGORT_PROFIT")
    private String lgortProfit;

    @Column(name = "LGORT_PROFIT_NAME")
    private String lgortProfitName;

    /**
     * 工厂（文档要求）
     */
    @Column(name = "WERKS_DOC")
    private String werksDoc;

    /**
     * 文档要求
     */
    @Column(name = "KZDKZ")
    private String kzdkz;

    /**
     * 检验类型
     */
    @Column(name = "ART")
    private String art;

    /**
     * 激活标识
     */
    @Column(name = "AKTIV")
    private String aktiv;

    /**
     * 过账到质检（质检）
     */
    @Column(name = "INSMK_QM")
    private String insmkQm;

    /**
     * 带任务清单检验
     */
    @Column(name = "PPL")
    private String ppl;

    /**
     * 自动分配
     */
    @Column(name = "APP")
    private String app;

    /**
     * 检查特性
     */
    @Column(name = "MER")
    private String mer;

    /**
     * 允许略过
     */
    @Column(name = "DYN")
    private String dyn;

    /**
     * 工厂（评估分类）
     */
    @Column(name = "BWKEY")
    private String bwkey;

    /**
     * 移动平均价
     */
    @Column(name = "VERPR")
    private String verpr;

    /**
     * 标准价
     */
    @Column(name = "STPRS")
    private String stprs;

    /**
     * 不参与成本核算
     */
    @Column(name = "NCOST")
    private String ncost;

    /**
     * 维护状态（0草稿；1保存；2分发）
     */
    @Column(name = "STATUS")
    private String status;



    @Column(name = "dispo_name")
    private String dispoName;

    @Column(name = "minbe_name")
    private String minbeName;



    @Transient
    private String billCode;
    @Transient
    private Integer statusId;
    @Transient
    private String personMemberName;
    @Transient
    private Date fillinDate;
    @Transient
    private String maintenanceType;
    @Transient
    private String businessUsage;
    @Transient
    private String businessCode;

    //物品总属性
    @Transient
    private String genericName;
    @Transient
    private String applicableStandard;
    @Transient
    private String  baseUnit;
    @Transient
    private String specifications;
    @Transient
    private String material;
    @Transient
    private String design;
    @Transient
    private String  size;
    @Transient
    private String  brand;
    @Transient
    private String  brandName;
    @Transient
    private String materialUsage;
    @Transient
    private String itemAttributes;
    @Transient
    private Integer distribute;
    @Transient
    private String kind;
}