package com.huigou.topsun.sap.nonProdApply.controller;


import com.huigou.cache.DictUtil;
import com.huigou.topsun.base.bsnMessage.appliction.BsnMessageApplication;
import com.huigou.topsun.base.bsnMessage.domain.BsnMessageReject;
import com.huigou.topsun.base.bsnMessage.repository.BsnMessageExecuteRepository;
import com.huigou.topsun.base.bsnMessage.repository.BsnMessageSponsorRepository;
import com.huigou.topsun.sap.common.DefaultHttpClient;
import com.huigou.topsun.sap.nonProdApply.application.NonProdApplyApplication;
import com.huigou.topsun.sap.nonProdApply.application.NonProdApplyDeptApplication;
import com.huigou.topsun.sap.nonProdApply.domain.NonProdApplyBaseInfo;
import com.huigou.topsun.sap.nonProdApply.domain.SapNonProdApplyDept;
import com.huigou.topsun.sap.nonProdApply.domain.query.NonProdApplyBaseInfoQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.doc.attachment.application.AttachmentApplication;
import com.huigou.uasp.bmp.doc.attachment.domain.model.Attachment;
import com.huigou.uasp.bmp.opm.application.OrgApplication;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.Constants;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.*;

@Controller
@ControllerMapping("/sapNonProdApplyNext")
public class NonProdApplyNextController extends CommonController {

    protected String getPagePath() {
        return "/biz/topsun/sap/nonProdApply/";
    }

    @Autowired
    NonProdApplyApplication nonProdApplyApplication;
    @Autowired
    NonProdApplyDeptApplication nonProdApplyDeptApplication;
    @Autowired
    BsnMessageApplication bsnMessageApplication;
    @Autowired
    BsnMessageSponsorRepository bsnMessageSponsorRepository;
    @Autowired
    BsnMessageExecuteRepository bsnMessageExecuteRepository;
    @Autowired
    OrgApplication orgApplication;
    @Autowired
    DefaultHttpClient defaultHttpClient;
    @Autowired
    private AttachmentApplication attachmentApplication;

    public String forwardNonProdApplyNext() {
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
//        this.putAttribute("active", ActiveStatus.UNFINISHED.getValue() );//定义流程环节的id
        if (StringUtil.isNotBlank(sdo.getString("prod"))){  //首页进入的产品信息 如果ID是传的ApplyDeptId
            SapNonProdApplyDept applyDept=nonProdApplyDeptApplication.getNonProdApplyDeptById(id);
            if (applyDept!=null){
               id=applyDept.getBaseInfoId();
            }
        }
        NonProdApplyBaseInfo nonProdApplyBaseInfo = nonProdApplyApplication.loadNonProdApplyBaseInfoById(id);
        nonProdApplyBaseInfo.setApplyType("0");
        this.putAttribute("applyType", "0");
        SapNonProdApplyDept nonProdApplyDept = nonProdApplyDeptApplication.getNonProdApplyDeptByBaseInfoId(id);
        Map <String,String>dictMapUsage=DictUtil.getDictionary("serviceusage");
        String dictMapUsages="";
        for (Map.Entry<String, String> entry: dictMapUsage.entrySet()) {
           // String key = entry.getKey().toUpperCase();
            dictMapUsages+=entry.getKey().toUpperCase()+","+entry.getValue()+";";
         }
        dictMapUsages=dictMapUsages.substring(0,dictMapUsages.length()-1);
        this.putAttribute("dictUsages",dictMapUsages);
        this.putAttribute("isAll","0");
        if (nonProdApplyBaseInfo.getBusinessUsage()!=null&&nonProdApplyBaseInfo.getBusinessUsage().split(",").length==dictMapUsages.split(";").length){
            this.putAttribute("isAll","1");
        }
        String page = "nonProdApplyNext";
        if (nonProdApplyBaseInfo.getMaintenanceType().equals("new") && nonProdApplyBaseInfo.getKind().equals("materiel")){
            page = "materialApplyNext";
        } else if (nonProdApplyBaseInfo.getMaintenanceType().equals("modify")){
            nonProdApplyBaseInfo.setApplyType("1");
            this.putAttribute("applyType", "1");
        } else if (nonProdApplyBaseInfo.getMaintenanceType().equals("extend")){
            nonProdApplyBaseInfo.setApplyType("2");
            this.putAttribute("applyType", "2");

           // NonProdApplyBaseInfo sourceNonProdApplyBaseInfo=nonProdApplyApplication.loadNonProdApplyBaseInfoById(nonProdApplyBaseInfo.getSourceId());
            String  usedBusiness=nonProdApplyApplication.getChangeBusinessUsage(id,"扩展");
            //去掉当前的
            usedBusiness=usedBusiness.replaceAll(nonProdApplyBaseInfo.getBusinessUsage(),"");
            String []usages=usedBusiness.split(",");//sourceNonProdApplyBaseInfo.getBusinessUsage().split(",");

            nonProdApplyBaseInfo.setBusinessUsageSeled(usedBusiness);
            Map <String, String>unMapTmp=new HashMap();
            for (Map.Entry<String, String> entry : dictMapUsage.entrySet()) {
                String key = entry.getKey().toUpperCase();
                if (!"K".equals(key)) {
                    unMapTmp.put(key, entry.getValue());
                }
            }
            this.putAttribute("businessUsageUnSeledList",unMapTmp);
        }
        int slen=0;
        if (StringUtil.isNotBlank(nonProdApplyBaseInfo.getBusinessUsage())){
            slen=nonProdApplyBaseInfo.getBusinessUsage().split(",").length;
        }
        this.putAttribute("busiLens",slen);

        List<Attachment> frontAttachments = attachmentApplication.queryAttachments("frontPicture", id);
        List<Attachment> backAttachments = attachmentApplication.queryAttachments("backPicture", id);

        if (frontAttachments.size() > 0) {
            Attachment attachment = frontAttachments.get(0);
            this.putAttribute("frontPicturePath", StringUtil.encode(attachment.getPath()));
        }
        if (backAttachments.size() > 0) {
            Attachment attachment = backAttachments.get(0);
            this.putAttribute("backPicturePath", StringUtil.encode(attachment.getPath()));
        }
        if (nonProdApplyDept != null) {
            getBaseInfoAttrs(nonProdApplyBaseInfo, nonProdApplyDept);
            if (nonProdApplyBaseInfo.getDistribute()!=null){
                this.putAttribute("active",nonProdApplyBaseInfo.getDistribute());
            } else { // 未分发
                this.putAttribute("active",0);
            }
            if ("product".equals(nonProdApplyDept.getKind())){
                this.putAttribute("kind","product");
            } else{
                this.putAttribute("kind","materiel");
            }
            //return forward("nonProdApplyNext", nonProdApplyDept);
            return forward(page, nonProdApplyDept);
        } else {
            this.putAttribute("active",0);
            //return forward("nonProdApplyNext", nonProdApplyBaseInfo);
            return forward(page, nonProdApplyBaseInfo);
        }
    }


    /**
     * 保存 /提交
     */
    public String saveSapNonProdApplyDept() {
        SDO sdo = this.getSDO();
        if (StringUtil.isNotBlank(sdo.getString("maktx"))) {
            NonProdApplyBaseInfoQueryRequest query = new NonProdApplyBaseInfoQueryRequest();
            query.setMaktx(sdo.getString("maktx"));
            Map<String, Object> map=nonProdApplyApplication.slicedNonApplyBaseInfoByMaktx(query);
            List <Map <String,Object>>baseList=(List)map.get("Rows");
            sdo.putProperty("baseList",baseList);
        }
        Map<String, Object> map = nonProdApplyDeptApplication.saveSapNonProdApplyDept(sdo);
        return toResult(map);
    }


    /**
     * 分发表单
     */
    public String distributeSapNonProdApplyDept() {
        SDO sdo = this.getSDO();
        nonProdApplyDeptApplication.distributeSapNonProdApplyDept(sdo);
        return success();
    }

    public String slicedRejectCauseList(){
        SDO sdo = this.getSDO();
        String meId = sdo.getString("meId");
        List<BsnMessageReject> rejectAll = bsnMessageApplication.getRejectDetail(meId);
        return toResult(rejectAll);
    }

public void getBaseInfoAttrs(NonProdApplyBaseInfo baseInfo,SapNonProdApplyDept nonProdApplyDept){
        nonProdApplyDept.setBillCode(baseInfo.getBillCode());
        nonProdApplyDept.setStatusId(baseInfo.getStatusId());
        nonProdApplyDept.setPersonMemberName(baseInfo.getPersonMemberName());
        nonProdApplyDept.setFillinDate(baseInfo.getFillinDate());
        nonProdApplyDept.setMaintenanceType(baseInfo.getMaintenanceType());
        nonProdApplyDept.setBusinessUsage(baseInfo.getBusinessUsage());

        nonProdApplyDept.setId(nonProdApplyDept.getBaseInfoId());
        //物品总属性
        nonProdApplyDept.setGenericName(baseInfo.getGenericName());

        nonProdApplyDept.setApplicableStandard(baseInfo.getApplicableStandard());
        nonProdApplyDept.setBaseUnit(baseInfo.getBaseUnit());
        nonProdApplyDept.setSpecifications(baseInfo.getSpecifications());
        nonProdApplyDept.setMaterial(baseInfo.getMaterial());
        nonProdApplyDept.setDesign(baseInfo.getDesign());
        nonProdApplyDept.setSize(baseInfo.getSize());
        nonProdApplyDept.setBrand(baseInfo.getBrand());
        nonProdApplyDept.setBrandName(baseInfo.getBrandName());

        nonProdApplyDept.setMaterialUsage(baseInfo.getMaterialUsage());
        nonProdApplyDept.setItemAttributes(baseInfo.getItemAttributes());
        nonProdApplyDept.setDistribute(baseInfo.getDistribute());
        nonProdApplyDept.setKind(baseInfo.getKind());
        nonProdApplyDept.setCreatedDate(baseInfo.getCreatedDate());

        nonProdApplyDept.setMaktxRemEn(baseInfo.getMaktxRemEn());
        nonProdApplyDept.setMaktxRemZh(baseInfo.getMaktxRemZh());
        nonProdApplyDept.setTextDescription(baseInfo.getTextDescription());

        nonProdApplyDept.setBaseUnitName(baseInfo.getBaseUnitName());
        if (StringUtil.isNotBlank(baseInfo.getBaseUnit()) && StringUtil.isBlank(nonProdApplyDept.getMeins())){
            nonProdApplyDept.setMeins(baseInfo.getBaseUnit());
            nonProdApplyDept.setMeinsName(baseInfo.getBaseUnitName());
        }
    }

    /**
     * 驳回
     * @return
     */
    public String rejectNonProdApplyDept() {
        SDO sdo = this.getSDO();
        nonProdApplyDeptApplication.rejectNonProdApplyDept(sdo);
        return success();
    }

    public String markMaterialStatus(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        nonProdApplyDeptApplication.unfreezeMaterialStatus(ids);
        return success();
    }
}


