package com.huigou.topsun.sap.fixedAssets.domain;

import com.huigou.data.domain.model.AbstractEntity;
import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * SAP固定资产转移
 *
 * @TableName sap_fixed_assets_move_item
 */
@Table(name = "sap_fixed_assets_move_item")
@Entity
@Data
public class SapFixedAssetsMoveItem extends AbstractEntity {
    /**
     * SAP固定资产转移ID
     */
    @Column(name = "sap_fixed_assets_move_id")
    private String sapFixedAssetsMoveId;

    /**
     * 主资产号
     */
    @Column(name = "anln1")
    private String anln1;

    /**
     * 公司代码（必填）
     */
    @Column(name = "bukrs")
    private String bukrs;

    /**
     * 申请日期
     */
    @Column(name = "adatu")
    private Date adatu;

    /**
     * 原成本中心（必填）
     */
    @Column(name = "from_kostl")
    private String fromKostl;

    /**
     * 成本中心（必填）
     */
    @Column(name = "kostl")
    private String kostl;
}