package com.huigou.topsun.sap.fixedAssets.domain;

import com.huigou.data.domain.model.FlowBillAbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * SAP固定资产主数据
 *
 * @TableName sap_fixed_assets
 */
@Table(name = "sap_fixed_assets")
@Entity
@Data
public class SapFixedAssets extends FlowBillAbstractEntity {
    /**
     * BPM单号
     */
    @Column(name = "zfibpmnr")
    private String zfibpmnr;

    /**
     * 创建标识
     * 用于标识数据是新增或修改，1为新增，2为修改。（必填）
     */
    @Column(name = "zfiflg")
    private Integer zfiflg;

    /**
     * 主资产号
     * ;资产编号内部生成，当创建标识为2，即修改时，主资产号为必输。
     */
    @Column(name = "anln1")
    private String anln1;

    /**
     * 资产分类
     * 当创建标识为1，即创建时，资产分类必输。
     */
    @Column(name = "anlkl")
    private String anlkl;

    @Column(name = "anlkl_name")
    private String anlklName;

    /**
     * 公司代码（必填）
     */
    @Column(name = "bukrs")
    private String bukrs;

    @Column(name = "bukrs_name")
    private String bukrsName;

    /**
     * 文本（必填）
     */
    @Column(name = "txt50")
    private String txt50;

    /**
     * 规格型号
     */
    @Column(name = "txa50")
    private String txa50;

    /**
     * 存货号；存放地点
     */
    @Column(name = "invnr")
    private String invnr;

    /**
     * 数量
     */
    @Column(name = "menge")
    private BigDecimal menge;

    /**
     * 基本计量单位
     */
    @Column(name = "meins")
    private String meins;

    @Column(name = "meins_name")
    private String meinsName;

    /**
     * 成本中心（必填）
     */
    @Column(name = "kostl")
    private String kostl;

    /**
     * 成本中心（必填）
     */
    @Column(name = "kostl_name")
    private String kostlName;

    /**
     * 责任成本中心
     */
    @Column(name = "kostlv")
    private String kostlv;

    /**
     * 责任成本中心
     */
    @Column(name = "kostlv_name")
    private String kostlvName;

    private static final long serialVersionUID = 1L;
    /**
     * ***********返回接收数据*****************
     */
    /**
     * 消息类型
     */
    @Column(name = "TYPE")
    private String type;
    /**
     * 消息文本
     */
    @Column(name = "MESSAGE")
    private String message;

    /**
     * 消息文本
     */
    @Column(name = "MESSAGE_V1")
    private String messageV1;

    /**
     * 使用情况
     * 1-外购、2-自制、3-合并新增
     */
    @Column(name = "ORD41")
    private String ord41;

    /**
     * 取得方式
     * 1-在用、2-闲置、3-在建 、4-停建
     */
    @Column(name = "ORD42")
    private String ord42;

    @Override
    protected String getCodeRuleId() {
        return "sapFixedAssets";
    }

}