package com.huigou.topsun.sap.fixedAssets.controller;

import com.huigou.topsun.sap.fixedAssets.application.SapFixedAssetsMoveItemApplication;
import com.huigou.topsun.sap.fixedAssets.domain.query.SapFixedAssetsMoveQueryRequest;
import com.huigou.topsun.sap.purchase.application.SapPurchaseItemApplication;
import com.huigou.topsun.sap.purchase.domain.query.SapPurchaseItemQueryRequest;
import com.huigou.topsun.sap.purchase.repository.SapPurchaseItemRepository;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/02/16:34
 * @Description:
 */
@Controller
@ControllerMapping("/sapFixedAssetsMoveItem")
public class SapFixedAssetsMoveItemController extends CommonController {
    @Autowired
    private SapFixedAssetsMoveItemApplication sapFixedAssetsMoveItemApplication;

    public String querySapFixedAssetsMoveItems(){
        SDO sdo = this.getSDO();
        SapFixedAssetsMoveQueryRequest queryRequest = sdo.toQueryRequest(SapFixedAssetsMoveQueryRequest.class);
        Map<String, Object> map = sapFixedAssetsMoveItemApplication.querySapFixedAssetsMoveItems(queryRequest);
        return toResult(map);
    }

    public String deleteSapFixedAssetsMoveItems(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        sapFixedAssetsMoveItemApplication.deleteByIds(ids);
        return success();
    }
}
