package com.huigou.topsun.sap.fixedAssets.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.sap.fixedAssets.application.SapFixedAssetsMoveApplication;
import com.huigou.topsun.sap.fixedAssets.domain.SapFixedAssetsMove;
import com.huigou.topsun.sap.fixedAssets.domain.TmpFixedAssessMoveData;
import com.huigou.topsun.sap.fixedAssets.domain.query.SapFixedAssetsMoveQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/02/16:34
 * @Description:
 */
@Controller
@ControllerMapping("/sapFixedAssetsMove")
public class SapFixedAssetsMoveController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/fixedAssets/sapFixedAssetsMove/";
    }

    @Resource
    private SapFixedAssetsMoveApplication sapFixedAssetsMoveApplication;

    public String forwardSapFixedAssetsMoveList(){
        return forward("sapFixedAssetsMoveList");
    }

    public String slicedSapFixedAssetsMoveList(){
        SDO sdo = this.getSDO();
        SapFixedAssetsMoveQueryRequest queryRequest = sdo.toQueryRequest(SapFixedAssetsMoveQueryRequest.class);
        Map<String, Object> map = sapFixedAssetsMoveApplication.getFixedAssetsMoveList(queryRequest);
        return toResult(map);
    }

    public String forwardSapFixedAssetsMoveDetail(){
        this.putAttribute("processDefinitionKey", SapFixedAssetsMoveApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        SapFixedAssetsMove sapFixedAssetsMove = new SapFixedAssetsMove();
        sapFixedAssetsMove.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        sapFixedAssetsMove.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("sapFixedAssetsMoveDetail",sapFixedAssetsMove);
    }

    public String showFixedAssetsMove(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        SapFixedAssetsMove sapFixedAssetsMove = sapFixedAssetsMoveApplication.getFixedAssetsMoveById(id);
        return forward("sapFixedAssetsMoveDetail",sapFixedAssetsMove);
    }


    /*
     *返回导入数据
     */
    public String importExcelData() {
        SDO sdo = this.getSDO();
        String batchNumber = sdo.getString("batchNumber");
        List<TmpFixedAssessMoveData> dataList=sapFixedAssetsMoveApplication.importExcelData(batchNumber);
        //   return dataList;
        return toResult(dataList);
    }
}
