package com.huigou.topsun.sap.fixedAssets.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.fixedAssets.application.SapFixedAssetsMoveApplication;
import com.huigou.topsun.sap.fixedAssets.application.SapFixedAssetsMoveItemApplication;
import com.huigou.topsun.sap.fixedAssets.domain.SapFixedAssess;
import com.huigou.topsun.sap.fixedAssets.domain.SapFixedAssetsMove;
import com.huigou.topsun.sap.fixedAssets.domain.SapFixedAssetsMoveItem;
import com.huigou.topsun.sap.fixedAssets.domain.TmpFixedAssessMoveData;
import com.huigou.topsun.sap.fixedAssets.domain.query.SapFixedAssetsMoveQueryRequest;
import com.huigou.topsun.sap.fixedAssets.repository.SapFixedAssetsMoveRepository;
import com.huigou.topsun.sap.fixedAssets.repository.TmpFixedAssessMoveDataRepository;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.bpm.FlowBroker;
import com.huigou.util.ClassHelper;
import com.huigou.util.DateUtil;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.DelegateTask;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/02/16:35
 * @Description:
 */
@Service("sapFixedAssetsMoveApplication")
public class SapFixedAssetsMoveApplicationImpl extends FlowBroker implements SapFixedAssetsMoveApplication {
    @Autowired
    private SapFixedAssetsMoveRepository sapFixedAssetsMoveRepository;
    @Autowired
    private SapFixedAssetsMoveItemApplication sapFixedAssetsMoveItemApplication;
    @Autowired
    private TmpFixedAssessMoveDataRepository tmpFixedAssessMoveDataRepository;
    @Override
    public Map<String, Object> getFixedAssetsMoveList(SapFixedAssetsMoveQueryRequest queryRequest) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "sapFixedAssetsMove");
        QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
        queryModel.putDictionary("status",BizBillStatus.getMap());
        Map<String, Object> map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        return map;
    }

    @Override
    public SapFixedAssetsMove getFixedAssetsMoveById(String id) {
        return sapFixedAssetsMoveRepository.findOne(id);
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            sapFixedAssetsMoveRepository.delete(id);
        });
    }

    @Override
    public List<TmpFixedAssessMoveData> importExcelData(String batchNumber) {
        List<TmpFixedAssessMoveData>  dataList = tmpFixedAssessMoveDataRepository.findByBatchNumber(batchNumber);
        return dataList;
    }

    /**
     * 设置任务名称
     */
    @Override
    protected void setTaskDescription(DelegateTask delegateTask) {
        String bizId = delegateTask.getExecution().getProcessBusinessKey();
        delegateTask.setDescription(this.getApprovalSubjectName(bizId));
    }

    /**
     * 获取任务标题
     *
     * @param bizId
     * @return
     */
    private String getApprovalSubjectName(String bizId) {
        SapFixedAssetsMove fixedAssetsMove = this.sapFixedAssetsMoveRepository.findOne(bizId);
        //查询 单据日期
        String fillinDateStr = DateUtil.getDateFormat("yyyy-MM-dd HH:mm:ss", fixedAssetsMove.getFillinDate());
        //设置标题
        return String.format("%s-%s(%s)", "固定资产转移", fixedAssetsMove.getBillCode(), fillinDateStr);
    }

    @Override
    protected void onEnd(DelegateExecution delegateExecution) {
        //super.onEnd(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        BizBillStatus status = approvePassed() ? BizBillStatus.COMPLETED : BizBillStatus.ABORTED;
        SapFixedAssetsMove fixedAssetsMove = sapFixedAssetsMoveRepository.findOne(bizId);
        fixedAssetsMove.setStatusId(status.getId());
        sapFixedAssetsMoveRepository.save(fixedAssetsMove);
    }

    @Override
    protected void onAbortProcessInstance(DelegateExecution delegateExecution) {
        super.onAbortProcessInstance(delegateExecution);
        String bizId = delegateExecution.getProcessBusinessKey();
        SapFixedAssetsMove fixedAssetsMove = sapFixedAssetsMoveRepository.findOne(bizId);
        fixedAssetsMove.setStatusId(BizBillStatus.ABORTED.getId());
        sapFixedAssetsMoveRepository.save(fixedAssetsMove);
    }

    @Override
    protected void onBack(DelegateTask delegateTask, String destActivityId) {
        super.onBack(delegateTask, destActivityId);
        if ("Apply".equalsIgnoreCase(destActivityId)) {
            String bizId = delegateTask.getExecution().getProcessBusinessKey();
            SapFixedAssetsMove fixedAssetsMove = sapFixedAssetsMoveRepository.findOne(bizId);
            fixedAssetsMove.setStatusId(BizBillStatus.APPLYING.getId());
            sapFixedAssetsMoveRepository.save(fixedAssetsMove);
        }
    }

    @Override
    protected Map<String, Object> getProcessBizParams(String bizId) {
        return ClassHelper.toMap(sapFixedAssetsMoveRepository.getOne(bizId));
    }

    @Override
    protected String saveBizAndApprovalData() {
        super.saveBizAndApprovalData();
        SapFixedAssetsMove fixedAssetsMove = getBizEntity(SapFixedAssetsMove.class);
        if (fixedAssetsMove.isNew()) {
            fixedAssetsMove.setStatusId(BizBillStatus.APPLYING.getId());
        } else {
            fixedAssetsMove = (SapFixedAssetsMove) commonDomainService.loadAndFillinProperties(fixedAssetsMove);
        }
        fixedAssetsMove = sapFixedAssetsMoveRepository.save(fixedAssetsMove);
        List<SapFixedAssetsMoveItem> items = getBizEntities(SapFixedAssetsMoveItem.class, "items");
        sapFixedAssetsMoveItemApplication.saveSapFixedAssetsMoveItemItems(fixedAssetsMove.getId(),items);
        return fixedAssetsMove.getId();
    }
}
