package com.huigou.topsun.sap.finaCustomer.domain;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 
 * @TableName sap_fina_customer_bank
 */
@Table(name="sap_fina_customer_bank")
@Data
@Entity
public class FinaCustomerBank implements Serializable {


    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    private String id;

    /**
     * 主表id
     */
    @Column(name = "s_id")
    private String sId;

    /**
     * 银行所属国家/地区代码
     */
    @Column(name = "banks")
    private String banks;

    /**
     * 银行代码
     */
    @Column(name = "bankl")
    private String bankl;

    /**
     * 银行帐户号码
     */
    @Column(name = "bankn")
    private String bankn;

    /**
     * 财务机构名称
     */
    @Column(name = "banka")
    private String banka;

    /**
     * 银行细目的参考明细
     */
    @Column(name = "bkref")
    private String bkref;

    /**
     * 账户持有人姓名
     */
    @Column(name = "koinh")
    private String koinh;

    /**
     * 账户名称
     */
    @Column(name = "accname")
    private String accname;

    @Column(name = "sequence")
    private int sequence;

    private static final long serialVersionUID = 1L;
}